/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.type;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.types.DataType;

public abstract class ParquetField {
    private final DataType type;
    private final int repetitionLevel;
    private final int definitionLevel;
    private final boolean required;
    private final String[] path;
    @Nullable
    private final ParquetField variantFileType;

    public ParquetField(DataType type, int repetitionLevel, int definitionLevel, boolean required, String[] path) {
        this(type, repetitionLevel, definitionLevel, required, path, null);
    }

    public ParquetField(DataType type, int repetitionLevel, int definitionLevel, boolean required, String[] path, @Nullable ParquetField variantFileType) {
        this.type = type;
        this.repetitionLevel = repetitionLevel;
        this.definitionLevel = definitionLevel;
        this.required = required;
        this.path = path;
        this.variantFileType = variantFileType;
    }

    public DataType getType() {
        return this.type;
    }

    public int getRepetitionLevel() {
        return this.repetitionLevel;
    }

    public int getDefinitionLevel() {
        return this.definitionLevel;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String[] path() {
        return this.path;
    }

    public Optional<ParquetField> variantFileType() {
        return Optional.ofNullable(this.variantFileType);
    }

    public abstract boolean isPrimitive();

    public String toString() {
        return "Field{type=" + this.type + ", repetitionLevel=" + this.repetitionLevel + ", definitionLevel=" + this.definitionLevel + ", required=" + this.required + "}";
    }
}

