/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.csv;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.csv.CsvOptions;
import org.apache.paimon.format.text.BaseTextFileReader;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class CsvFileReader
extends BaseTextFileReader {
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final CsvMapper CSV_MAPPER = new CsvMapper();
    private static final Map<String, CastExecutor<?, ?>> CAST_EXECUTOR_CACHE = new ConcurrentHashMap(32);
    private final CsvOptions formatOptions;
    private final CsvSchema schema;
    private final RowType dataSchemaRowType;
    private final RowType projectedRowType;
    private final int[] projectionMapping;
    private boolean headerSkipped = false;

    public CsvFileReader(FileIO fileIO, Path filePath, RowType rowReadType, RowType projectedRowType, CsvOptions options) throws IOException {
        super(fileIO, filePath, projectedRowType);
        this.dataSchemaRowType = rowReadType;
        this.projectedRowType = projectedRowType;
        this.formatOptions = options;
        this.projectionMapping = CsvFileReader.createProjectionMapping(rowReadType, projectedRowType);
        this.schema = CsvSchema.emptySchema().withQuoteChar(this.formatOptions.quoteCharacter().charAt(0)).withColumnSeparator(this.formatOptions.fieldDelimiter().charAt(0)).withEscapeChar(this.formatOptions.escapeCharacter().charAt(0));
        if (!this.formatOptions.includeHeader()) {
            this.schema.withoutHeader();
        }
    }

    @Override
    protected BaseTextFileReader.BaseTextRecordIterator createRecordIterator() {
        return new CsvRecordIterator();
    }

    @Override
    protected InternalRow parseLine(String line) throws IOException {
        return this.parseCsvLine(line, this.schema);
    }

    @Override
    protected void setupReading() throws IOException {
        if (this.formatOptions.includeHeader() && !this.headerSkipped) {
            this.bufferedReader.readLine();
            this.headerSkipped = true;
        }
    }

    protected static String[] parseCsvLineToArray(String line, CsvSchema schema) throws IOException {
        if (line == null || line.isEmpty()) {
            return new String[0];
        }
        return (String[])CSV_MAPPER.readerFor(String[].class).with(schema).readValue(line);
    }

    private static int[] createProjectionMapping(RowType rowReadType, RowType projectedRowType) {
        int[] mapping = new int[projectedRowType.getFieldCount()];
        for (int i = 0; i < projectedRowType.getFieldCount(); ++i) {
            String projectedFieldName = projectedRowType.getFieldNames().get(i);
            int readIndex = rowReadType.getFieldNames().indexOf(projectedFieldName);
            if (readIndex == -1) {
                throw new IllegalArgumentException(String.format("Projected field '%s' not found in read schema", projectedFieldName));
            }
            mapping[i] = readIndex;
        }
        return mapping;
    }

    private InternalRow parseCsvLine(String line, CsvSchema schema) throws IOException {
        String[] fields = CsvFileReader.parseCsvLineToArray(line, schema);
        int fieldCount = fields.length;
        Object[] projectedValues = new Object[this.projectedRowType.getFieldCount()];
        for (int i = 0; i < this.projectedRowType.getFieldCount(); ++i) {
            int readIndex = this.projectionMapping[i];
            if (readIndex < fieldCount) {
                String field = fields[readIndex];
                if (field == null || field.isEmpty() || field.equals(this.formatOptions.nullLiteral())) {
                    projectedValues[i] = null;
                    continue;
                }
                projectedValues[i] = this.parseFieldOptimized(field.trim(), this.dataSchemaRowType.getTypeAt(readIndex));
                continue;
            }
            projectedValues[i] = null;
        }
        return GenericRow.of(projectedValues);
    }

    private Object parseFieldOptimized(String field, DataType dataType) {
        if (field == null || field.equals(this.formatOptions.nullLiteral())) {
            return null;
        }
        DataTypeRoot typeRoot = dataType.getTypeRoot();
        switch (typeRoot) {
            case TINYINT: {
                return Byte.parseByte(field);
            }
            case SMALLINT: {
                return Short.parseShort(field);
            }
            case INTEGER: {
                return Integer.parseInt(field);
            }
            case BIGINT: {
                return Long.parseLong(field);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(field));
            }
            case DOUBLE: {
                return Double.parseDouble(field);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(field);
            }
            case CHAR: 
            case VARCHAR: {
                return BinaryString.fromString(field);
            }
            case BINARY: 
            case VARBINARY: {
                return BASE64_DECODER.decode(field);
            }
        }
        return this.useCachedCastExecutor(field, dataType);
    }

    private Object useCachedCastExecutor(String field, DataType dataType) {
        String cacheKey = dataType.toString();
        CastExecutor cast = CAST_EXECUTOR_CACHE.computeIfAbsent(cacheKey, k -> CastExecutors.resolve(DataTypes.STRING(), dataType));
        if (cast != null) {
            return cast.cast(BinaryString.fromString(field));
        }
        return BinaryString.fromString(field);
    }

    private class CsvRecordIterator
    extends BaseTextFileReader.BaseTextRecordIterator {
        private CsvRecordIterator() {
            super(CsvFileReader.this);
        }
    }
}

