/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCalciteClasses {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkCalciteClasses.class);
    private static final String Flink_PLANNER_MODULE_CLASS = "org.apache.flink.table.planner.loader.PlannerModule";
    private static final String PLANNER_MODULE_METHOD = "getInstance";
    private static final String SUBMODULE_CLASS_LOADER = "submoduleClassLoader";
    private static final ClassLoader submoduleClassLoader;
    private final SqlNodeListDelegate sqlNodeListDelegate = new SqlNodeListDelegate();
    private final SqlLiteralDelegate sqlLiteralDelegate = new SqlLiteralDelegate();
    private final SqlBasicCallDelegate sqlBasicCallDelegate = new SqlBasicCallDelegate();
    private final SqlOperatorDelegate sqlOperatorDelegate = new SqlOperatorDelegate();
    private final SqlKindDelegate sqlKindDelegate = new SqlKindDelegate();
    private final SqlParserDelegate sqlParserDelegate = new SqlParserDelegate();
    private final LexDelegate lexDelegate = new LexDelegate();
    private final ConfigDelegate configDelegate = new ConfigDelegate();
    private final SqlIdentifierDelegate sqlIdentifierDelegate = new SqlIdentifierDelegate();

    private static ClassLoader initCalciteClassLoader() throws Exception {
        Class<?> plannerModuleClass = Class.forName(Flink_PLANNER_MODULE_CLASS);
        Method getInstanceMethod = plannerModuleClass.getDeclaredMethod(PLANNER_MODULE_METHOD, new Class[0]);
        getInstanceMethod.setAccessible(true);
        Object plannerModuleInstance = getInstanceMethod.invoke(null, new Object[0]);
        Field submoduleClassLoaderField = plannerModuleClass.getDeclaredField(SUBMODULE_CLASS_LOADER);
        submoduleClassLoaderField.setAccessible(true);
        return (ClassLoader)submoduleClassLoaderField.get(plannerModuleInstance);
    }

    private static Object invokeMethod(Class<?> clazz, Object object, String methodName, Class<?>[] argsClass, Object[] args) throws Exception {
        Method method = clazz.getMethod(methodName, argsClass);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    private static Class<?> loadCalciteClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, submoduleClassLoader);
    }

    public SqlNodeListDelegate sqlNodeListDelegate() {
        return this.sqlNodeListDelegate;
    }

    public SqlLiteralDelegate sqlLiteralDelegate() {
        return this.sqlLiteralDelegate;
    }

    public SqlBasicCallDelegate sqlBasicCallDelegate() {
        return this.sqlBasicCallDelegate;
    }

    public SqlOperatorDelegate sqlOperatorDelegate() {
        return this.sqlOperatorDelegate;
    }

    public SqlKindDelegate sqlKindDelegate() {
        return this.sqlKindDelegate;
    }

    public SqlParserDelegate sqlParserDelegate() {
        return this.sqlParserDelegate;
    }

    public LexDelegate lexDelegate() {
        return this.lexDelegate;
    }

    public ConfigDelegate configDelegate() {
        return this.configDelegate;
    }

    public SqlIdentifierDelegate sqlIndentifierDelegate() {
        return this.sqlIdentifierDelegate;
    }

    static {
        boolean calciteFound = false;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            currentClassLoader.loadClass("org.apache.calcite.sql.parser.SqlParser");
            calciteFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            submoduleClassLoader = calciteFound ? currentClassLoader : FlinkCalciteClasses.initCalciteClassLoader();
        }
        catch (Exception e) {
            LOG.error(String.format("Load Calcite class Fail: %s", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class SqlLiteralDelegate {
        private static final String CLASS_NAME = "org.apache.calcite.sql.SqlLiteral";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlLiteral");

        public boolean instanceOfSqlLiteral(Object sqlNode) throws Exception {
            return this.clazz.isAssignableFrom(sqlNode.getClass());
        }

        public String toValue(Object sqlNode) throws Exception {
            return (String)FlinkCalciteClasses.invokeMethod(this.clazz, sqlNode, "toValue", new Class[0], new Object[0]);
        }
    }

    public static class SqlNodeListDelegate {
        private static final String SQL_NODE_LIST = "org.apache.calcite.sql.SqlNodeList";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlNodeList");

        public List<?> getList(Object sqlNodeList) throws Exception {
            return (List)FlinkCalciteClasses.invokeMethod(this.clazz, sqlNodeList, "getList", new Class[0], new Object[0]);
        }
    }

    public static class SqlIdentifierDelegate {
        private static final String SQL_IDENTIFIER = "org.apache.calcite.sql.SqlIdentifier";
        private final Class<?> identifierClazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlIdentifier");

        public boolean instanceOfSqlIdentifier(Object sqlNode) throws Exception {
            return this.identifierClazz.isAssignableFrom(sqlNode.getClass());
        }
    }

    public static class SqlOperatorDelegate {
        static final String SQL_OPERATOR = "org.apache.calcite.sql.SqlOperator";
        private final Class<?> sqlOperatorClazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlOperator");
        static final String SQL_BINARY_OPERATOR = "org.apache.calcite.sql.SqlBinaryOperator";
        private final Class<?> sqlBinaryOperatorClazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlBinaryOperator");
        static final String SQL_SQL_POSTFIX_OPERATOR = "org.apache.calcite.sql.SqlPostfixOperator";
        private final Class<?> sqlPostfixOperatorClazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlPostfixOperator");
        static final String SQL_PREFIX_OPERATOR = "org.apache.calcite.sql.SqlPrefixOperator";
        private final Class<?> sqlPrefixOperatorClazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlPrefixOperator");

        public Object getKind(Object operator) throws Exception {
            return FlinkCalciteClasses.invokeMethod(this.sqlOperatorClazz, operator, "getKind", new Class[0], new Object[0]);
        }

        public boolean instanceOfSqlBinaryOperator(Object operator) throws Exception {
            return this.sqlBinaryOperatorClazz.isAssignableFrom(operator.getClass());
        }

        public boolean instanceOfSqlPostfixOperator(Object operator) throws Exception {
            return this.sqlPostfixOperatorClazz.isAssignableFrom(operator.getClass());
        }

        public boolean instanceOfSqlPrefixOperator(Object operator) throws Exception {
            return this.sqlPrefixOperatorClazz.isAssignableFrom(operator.getClass());
        }
    }

    public static class SqlBasicCallDelegate {
        static final String CLASS_NAME = "org.apache.calcite.sql.SqlBasicCall";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlBasicCall");

        public Object getOperator(Object basicCall) throws Exception {
            return FlinkCalciteClasses.invokeMethod(this.clazz, basicCall, "getOperator", new Class[0], new Object[0]);
        }

        public List<?> getOperandList(Object basicCall) throws Exception {
            return (List)FlinkCalciteClasses.invokeMethod(this.clazz, basicCall, "getOperandList", new Class[0], new Object[0]);
        }
    }

    public static class ConfigDelegate {
        static final String CLASS_NAME = "org.apache.calcite.sql.parser.SqlParser$Config";

        public Object withLex(Object config, Object lex) throws Exception {
            return FlinkCalciteClasses.invokeMethod(config.getClass(), config, "withLex", new Class[]{FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.config.Lex")}, new Object[]{lex});
        }
    }

    public static class SqlKindDelegate {
        private static final String CLASS_NAME = "org.apache.calcite.sql.SqlKind";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.SqlKind");

        public Object or() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("OR").get(null);
        }

        public Object and() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("AND").get(null);
        }

        public Object equals() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("EQUALS").get(null);
        }

        public Object notEquals() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("NOT_EQUALS").get(null);
        }

        public Object lessThan() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("LESS_THAN").get(null);
        }

        public Object lessThanOrEqual() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("LESS_THAN_OR_EQUAL").get(null);
        }

        public Object greaterThan() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("GREATER_THAN").get(null);
        }

        public Object greaterThanOrEqual() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("GREATER_THAN_OR_EQUAL").get(null);
        }

        public Object in() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("IN").get(null);
        }

        public Object isNull() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("IS_NULL").get(null);
        }

        public Object isNotNull() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("IS_NOT_NULL").get(null);
        }

        public Object not() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("NOT").get(null);
        }

        public Object notIn() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("NOT_IN").get(null);
        }
    }

    public static class LexDelegate {
        private static final String CLASS_NAME = "org.apache.calcite.config.Lex";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.config.Lex");

        public Object java() throws NoSuchFieldException, IllegalAccessException {
            return this.clazz.getField("JAVA").get(null);
        }
    }

    public static class SqlParserDelegate {
        private static final String CLASS_NAME = "org.apache.calcite.sql.parser.SqlParser";
        private final Class<?> clazz = FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.parser.SqlParser");

        public Object config() throws Exception {
            return FlinkCalciteClasses.invokeMethod(this.clazz, null, "config", new Class[0], new Object[0]);
        }

        public Object create(String whereSql, Object config) throws Exception {
            return FlinkCalciteClasses.invokeMethod(this.clazz, null, "create", new Class[]{String.class, FlinkCalciteClasses.loadCalciteClass("org.apache.calcite.sql.parser.SqlParser$Config")}, new Object[]{whereSql, config});
        }

        public Object parseExpression(Object sqlParser) throws Exception {
            return FlinkCalciteClasses.invokeMethod(this.clazz, sqlParser, "parseExpression", new Class[0], new Object[0]);
        }
    }
}

