/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.flink.source.SimpleSourceSplit;

public class SimpleSourceSplitSerializer
implements SimpleVersionedSerializer<SimpleSourceSplit> {
    public int getVersion() {
        return 0;
    }

    public byte[] serialize(SimpleSourceSplit split) throws IOException {
        if (split.splitId() == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                this.writeString(out, split.splitId());
                this.writeString(out, split.value());
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public SimpleSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        if (serialized.length == 0) {
            return new SimpleSourceSplit();
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            SimpleSourceSplit simpleSourceSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                String splitId = this.readString(in);
                String value = this.readString(in);
                simpleSourceSplit = new SimpleSourceSplit(splitId, value);
            }
            return simpleSourceSplit;
        }
    }

    private void writeString(DataOutputStream out, String str) throws IOException {
        byte[] bytes = str.getBytes();
        out.writeInt(bytes.length);
        out.write(str.getBytes());
    }

    private String readString(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes);
    }
}

