/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.listener;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionTimeExtractor;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMarkDoneTrigger {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionMarkDoneTrigger.class);
    private static final ListStateDescriptor<List<String>> PENDING_PARTITIONS_STATE_DESC = new ListStateDescriptor("mark-done-pending-partitions", (TypeSerializer)new ListSerializer((TypeSerializer)StringSerializer.INSTANCE));
    private final State state;
    private final PartitionTimeExtractor timeExtractor;
    @Nullable
    private final Long timeInterval;
    @Nullable
    private final Long idleTime;
    private final boolean markDoneWhenEndInput;
    private final Map<String, Long> pendingPartitions = new HashMap<String, Long>();

    public PartitionMarkDoneTrigger(State state, PartitionTimeExtractor timeExtractor, @Nullable Duration timeInterval, @Nullable Duration idleTime, boolean markDoneWhenEndInput) throws Exception {
        this(state, timeExtractor, timeInterval, idleTime, System.currentTimeMillis(), markDoneWhenEndInput);
    }

    public PartitionMarkDoneTrigger(State state, PartitionTimeExtractor timeExtractor, @Nullable Duration timeInterval, @Nullable Duration idleTime, long currentTimeMillis, boolean markDoneWhenEndInput) throws Exception {
        this.state = state;
        this.timeExtractor = timeExtractor;
        this.timeInterval = timeInterval == null ? null : Long.valueOf(timeInterval.toMillis());
        this.idleTime = idleTime == null ? null : Long.valueOf(idleTime.toMillis());
        this.markDoneWhenEndInput = markDoneWhenEndInput;
        state.restore().forEach(p -> this.pendingPartitions.put((String)p, currentTimeMillis));
    }

    public void notifyPartition(String partition) {
        this.notifyPartition(partition, System.currentTimeMillis());
    }

    @VisibleForTesting
    void notifyPartition(String partition, long currentTimeMillis) {
        if (!StringUtils.isNullOrWhitespaceOnly(partition)) {
            this.pendingPartitions.put(partition, currentTimeMillis);
        }
    }

    public List<String> donePartitions(boolean endInput) {
        return this.donePartitions(endInput, System.currentTimeMillis(), false);
    }

    List<String> donePartitions(boolean endInput, long currentTimeMillis) {
        return this.donePartitions(endInput, currentTimeMillis, false);
    }

    @VisibleForTesting
    List<String> donePartitions(boolean endInput, long currentTimeMillis, boolean watermarkEnabled) {
        if (endInput && this.markDoneWhenEndInput) {
            return new ArrayList<String>(this.pendingPartitions.keySet());
        }
        if (this.timeInterval == null || this.idleTime == null) {
            return Collections.emptyList();
        }
        LOG.debug("End input is true and markDoneWhenEndInput is enabled, mark all pending partitions done: {}", (Object)String.join((CharSequence)",", this.pendingPartitions.keySet()));
        ArrayList<String> needDone = new ArrayList<String>();
        Iterator<Map.Entry<String, Long>> iter = this.pendingPartitions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            String partition = entry.getKey();
            long lastUpdateTime = entry.getValue();
            LOG.debug("Partition {} is in progress, last update time: {}", (Object)partition, (Object)entry.getValue());
            Optional<LocalDateTime> partitionLocalDateTimeOpt = this.extractDateTime(partition);
            if (!partitionLocalDateTimeOpt.isPresent()) {
                LOG.debug("Partition {} is illegal, skip it", (Object)partition);
                iter.remove();
                continue;
            }
            long partitionStartTime = watermarkEnabled ? partitionLocalDateTimeOpt.get().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() : partitionLocalDateTimeOpt.get().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long partitionEndTime = partitionStartTime + this.timeInterval;
            lastUpdateTime = Math.max(lastUpdateTime, partitionEndTime);
            LOG.debug("Partition {} start time: {}, end time: {}, last update time after compare: {}", new Object[]{partition, partitionStartTime, partitionEndTime, lastUpdateTime});
            if (currentTimeMillis - lastUpdateTime > this.idleTime) {
                LOG.debug("Partition {} is idle for {} greater than idleTime {}, mark it done", new Object[]{partition, currentTimeMillis - lastUpdateTime, this.idleTime});
                needDone.add(partition);
                iter.remove();
                continue;
            }
            LOG.debug("Partition {} is idle for {} less than idleTime {}, no not mark it done", new Object[]{partition, currentTimeMillis - lastUpdateTime, this.idleTime});
        }
        LOG.debug("Need done partitions: {}", (Object)String.join((CharSequence)",", needDone));
        return needDone;
    }

    @VisibleForTesting
    Optional<LocalDateTime> extractDateTime(String partition) {
        try {
            return Optional.of(this.timeExtractor.extract(PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition))));
        }
        catch (DateTimeParseException e) {
            LOG.warn("Can't extract datetime from partition {}, please check configuration items 'partition.timestamp-formatter' and 'partition.timestamp-pattern'.", (Object)partition);
            return Optional.empty();
        }
    }

    public void snapshotState() throws Exception {
        this.state.update(new ArrayList<String>(this.pendingPartitions.keySet()));
    }

    public static PartitionMarkDoneTrigger create(CoreOptions coreOptions, boolean isRestored, OperatorStateStore stateStore) throws Exception {
        Options options = coreOptions.toConfiguration();
        return new PartitionMarkDoneTrigger(new PartitionMarkDoneTriggerState(isRestored, stateStore), new PartitionTimeExtractor(coreOptions.partitionTimestampPattern(), coreOptions.partitionTimestampFormatter()), options.get(FlinkConnectorOptions.PARTITION_TIME_INTERVAL), options.get(FlinkConnectorOptions.PARTITION_IDLE_TIME_TO_DONE), options.get(CoreOptions.PARTITION_MARK_DONE_WHEN_END_INPUT));
    }

    private static class PartitionMarkDoneTriggerState
    implements State {
        private final boolean isRestored;
        private final ListState<List<String>> pendingPartitionsState;

        public PartitionMarkDoneTriggerState(boolean isRestored, OperatorStateStore stateStore) throws Exception {
            this.isRestored = isRestored;
            this.pendingPartitionsState = stateStore.getListState(PENDING_PARTITIONS_STATE_DESC);
        }

        @Override
        public List<String> restore() throws Exception {
            Iterator state;
            ArrayList<String> pendingPartitions = new ArrayList<String>();
            if (this.isRestored && (state = ((Iterable)this.pendingPartitionsState.get()).iterator()).hasNext()) {
                pendingPartitions.addAll((Collection)state.next());
            }
            return pendingPartitions;
        }

        @Override
        public void update(List<String> partitions) throws Exception {
            this.pendingPartitionsState.update(Collections.singletonList(partitions));
        }
    }

    public static interface State {
        public List<String> restore() throws Exception;

        public void update(List<String> var1) throws Exception;
    }
}

