/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.coordinator;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.apache.paimon.utils.InstantiationUtil;

public class CoordinationResponseUtils {
    private static final String MAGIC_VERSION = "__paimon__";
    private static final long MAGIC_OFFSET = 20250627L;

    /*
     * Enabled aggressive exception aggregation
     */
    public static <R extends CoordinationResponse> CoordinationResponse wrap(R response) {
        CoordinationResponseSerializer serializer = new CoordinationResponseSerializer();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            CollectCoordinationResponse collectCoordinationResponse;
            try (DataOutputStream out = new DataOutputStream(baos);){
                serializer.serialize(response, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
                collectCoordinationResponse = new CollectCoordinationResponse(MAGIC_VERSION, 20250627L, Collections.singletonList(baos.toByteArray()));
            }
            return collectCoordinationResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to wrap CoordinationResponse \"%s\" with type \"%s\"", response, response.getClass().getCanonicalName()), e);
        }
    }

    public static <R extends CoordinationResponse> R unwrap(CoordinationResponse response) {
        try {
            CollectCoordinationResponse rawResponse = (CollectCoordinationResponse)response;
            List results = rawResponse.getResults((TypeSerializer)new CoordinationResponseSerializer());
            return (R)((CoordinationResponse)results.get(0));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to unwrap CoordinationResponse", e);
        }
    }

    private static class CoordinationResponseSerializer
    extends TypeSerializer<CoordinationResponse> {
        private CoordinationResponseSerializer() {
        }

        public void serialize(CoordinationResponse record, DataOutputView target) throws IOException {
            byte[] serialized = InstantiationUtil.serializeObject(record);
            target.writeInt(serialized.length);
            target.write(serialized);
        }

        public CoordinationResponse deserialize(DataInputView source) throws IOException {
            try {
                int length = source.readInt();
                byte[] serialized = new byte[length];
                source.readFully(serialized);
                return (CoordinationResponse)InstantiationUtil.deserializeObject(serialized, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to deserialize CoordinationResponse", e);
            }
        }

        public CoordinationResponse deserialize(CoordinationResponse reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<CoordinationResponse> duplicate() {
            return new CoordinationResponseSerializer();
        }

        public CoordinationResponse createInstance() {
            return new CoordinationResponse(){};
        }

        public CoordinationResponse copy(CoordinationResponse from) {
            throw new UnsupportedOperationException();
        }

        public CoordinationResponse copy(CoordinationResponse from, CoordinationResponse reuse) {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            return -1;
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            CoordinationResponse deserialize = this.deserialize(source);
            this.serialize(deserialize, target);
        }

        public boolean equals(Object obj) {
            return obj instanceof CoordinationResponseSerializer;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public TypeSerializerSnapshot<CoordinationResponse> snapshotConfiguration() {
            return new CoordinationResponseDeserializerSnapshot();
        }

        public static final class CoordinationResponseDeserializerSnapshot
        extends SimpleTypeSerializerSnapshot<CoordinationResponse> {
            public CoordinationResponseDeserializerSnapshot() {
                super(() -> new CoordinationResponseSerializer());
            }
        }
    }
}

