/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterRefresher {
    private static final Logger LOG = LoggerFactory.getLogger(WriterRefresher.class);
    private FileStoreTable table;
    private final Refresher refresher;
    private final Set<String> configGroups;

    private WriterRefresher(FileStoreTable table, Refresher refresher, Set<String> configGroups) {
        this.table = table;
        this.refresher = refresher;
        this.configGroups = configGroups;
    }

    @Nullable
    public static WriterRefresher create(boolean isStreaming, FileStoreTable table, Refresher refresher) {
        Set<String> configGroups;
        if (!isStreaming) {
            return null;
        }
        String refreshDetectors = Options.fromMap(table.options()).get(FlinkConnectorOptions.SINK_WRITER_REFRESH_DETECTORS);
        Set<String> set = configGroups = StringUtils.isNullOrWhitespaceOnly(refreshDetectors) ? null : Arrays.stream(refreshDetectors.split(",")).collect(Collectors.toSet());
        if (configGroups == null || configGroups.isEmpty()) {
            return null;
        }
        return new WriterRefresher(table, refresher, configGroups);
    }

    public void tryRefresh() {
        Optional<TableSchema> latestSchema = this.table.schemaManager().latest();
        if (!latestSchema.isPresent()) {
            return;
        }
        TableSchema latest = latestSchema.get();
        if (latest.id() > this.table.schema().id()) {
            try {
                Map<String, String> currentOptions = WriterRefresher.configGroups(this.configGroups, this.table.coreOptions());
                Map<String, String> newOptions = WriterRefresher.configGroups(this.configGroups, CoreOptions.fromMap(latest.options()));
                if (!Objects.equals(newOptions, currentOptions)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("table schema has changed, current schema-id:{}, try to update write with new schema-id:{}. current options:{}, new options:{}.", new Object[]{this.table.schema().id(), latestSchema.get().id(), currentOptions, newOptions});
                    }
                    this.table = this.table.copy((Map)newOptions);
                    this.refresher.refresh(this.table);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("update write failed.", e);
            }
        }
    }

    public static Map<String, String> configGroups(Set<String> groups, CoreOptions options) {
        HashMap<String, String> configs = new HashMap<String, String>();
        String externalPaths = "external-paths";
        if (groups.contains(externalPaths)) {
            configs.put(CoreOptions.DATA_FILE_EXTERNAL_PATHS.key(), options.dataFileExternalPaths());
            configs.put(CoreOptions.DATA_FILE_EXTERNAL_PATHS_STRATEGY.key(), options.externalPathStrategy().toString());
            configs.put(CoreOptions.DATA_FILE_EXTERNAL_PATHS_SPECIFIC_FS.key(), options.externalSpecificFS());
        }
        return configs;
    }

    public static interface Refresher {
        public void refresh(FileStoreTable var1) throws Exception;
    }
}

