/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.RowLevelModificationScanContext;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsDeletePushDown;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelDelete;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.logical.RowType;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.PredicateConverter;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.flink.sink.FlinkTableSink;
import org.apache.paimon.flink.sink.FlinkTableSinkBase;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.OnlyPartitionKeyEqualVisitor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.PrimaryKeyTableUtils;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.utils.Preconditions;

public abstract class SupportsRowLevelOperationFlinkTableSink
extends FlinkTableSinkBase
implements SupportsRowLevelUpdate,
SupportsRowLevelDelete,
SupportsDeletePushDown {
    @Nullable
    protected Predicate deletePredicate;

    public SupportsRowLevelOperationFlinkTableSink(ObjectIdentifier tableIdentifier, Table table, DynamicTableFactory.Context context, @Nullable LogStoreTableFactory logStoreTableFactory) {
        super(tableIdentifier, table, context, logStoreTableFactory);
    }

    @Override
    public DynamicTableSink copy() {
        FlinkTableSink copied = new FlinkTableSink(this.tableIdentifier, this.table, this.context, this.logStoreTableFactory);
        copied.staticPartitions = new HashMap(this.staticPartitions);
        copied.overwrite = this.overwrite;
        copied.deletePredicate = this.deletePredicate;
        return copied;
    }

    public SupportsRowLevelUpdate.RowLevelUpdateInfo applyRowLevelUpdate(List<Column> updatedColumns, @Nullable RowLevelModificationScanContext context) {
        boolean supportUpdate;
        if (this.table.primaryKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.format("%s can not support update, because there is no primary key.", this.table.getClass().getName()));
        }
        Options options = Options.fromMap(this.table.options());
        HashSet<String> primaryKeys = new HashSet<String>(this.table.primaryKeys());
        updatedColumns.forEach(column -> {
            if (primaryKeys.contains(column.getName())) {
                String errMsg = String.format("Updates to primary keys are not supported, primaryKeys (%s), updatedColumns (%s)", primaryKeys, updatedColumns.stream().map(Column::getName).collect(Collectors.toList()));
                throw new UnsupportedOperationException(errMsg);
            }
        });
        CoreOptions.MergeEngine mergeEngine = options.get(CoreOptions.MERGE_ENGINE);
        boolean bl = supportUpdate = mergeEngine == CoreOptions.MergeEngine.DEDUPLICATE || mergeEngine == CoreOptions.MergeEngine.PARTIAL_UPDATE;
        if (!supportUpdate) {
            throw new UnsupportedOperationException(String.format("Merge engine %s can not support batch update.", mergeEngine));
        }
        return new SupportsRowLevelUpdate.RowLevelUpdateInfo(){};
    }

    public SupportsRowLevelDelete.RowLevelDeleteInfo applyRowLevelDelete(@Nullable RowLevelModificationScanContext rowLevelModificationScanContext) {
        PrimaryKeyTableUtils.validatePKUpsertDeletable(this.table);
        return new SupportsRowLevelDelete.RowLevelDeleteInfo(){};
    }

    public boolean applyDeleteFilters(List<ResolvedExpression> list) {
        PrimaryKeyTableUtils.validatePKUpsertDeletable(this.table);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        RowType rowType = LogicalTypeConversion.toLogicalType(this.table.rowType());
        for (ResolvedExpression filter : list) {
            Optional<Predicate> predicate = PredicateConverter.convert(rowType, filter);
            if (predicate.isPresent()) {
                predicates.add(predicate.get());
                continue;
            }
            return false;
        }
        this.deletePredicate = predicates.isEmpty() ? null : PredicateBuilder.and(predicates);
        return this.canPushDownDeleteFilter();
    }

    public Optional<Long> executeDeletion() {
        Optional<Long> optional;
        block10: {
            BatchTableCommit commit = this.table.newBatchWriteBuilder().newCommit();
            try {
                if (this.deletePredicate == null) {
                    commit.truncateTable();
                } else {
                    Preconditions.checkArgument(this.deleteIsDropPartition());
                    commit.truncatePartitions(Collections.singletonList(this.deletePartitions()));
                }
                optional = Optional.empty();
                if (commit == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (commit != null) {
                        try {
                            commit.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            commit.close();
        }
        return optional;
    }

    private boolean canPushDownDeleteFilter() {
        CoreOptions options = CoreOptions.fromMap(this.table.options());
        return (this.deletePredicate == null || this.deleteIsDropPartition()) && !options.deleteForceProduceChangelog();
    }

    private boolean deleteIsDropPartition() {
        if (this.deletePredicate == null) {
            return false;
        }
        return this.deletePredicate.visit(new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys()));
    }

    private Map<String, String> deletePartitions() {
        if (this.deletePredicate == null) {
            return null;
        }
        OnlyPartitionKeyEqualVisitor visitor = new OnlyPartitionKeyEqualVisitor(this.table.partitionKeys());
        this.deletePredicate.visit(visitor);
        return visitor.partitions();
    }
}

