/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure.privilege;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.privilege.PrivilegeProcedureBase;
import org.apache.paimon.privilege.PrivilegeType;
import org.apache.paimon.utils.Preconditions;

public class GrantPrivilegeToUserProcedure
extends PrivilegeProcedureBase {
    public static final String IDENTIFIER = "grant_privilege_to_user";

    @ProcedureHint(argument={@ArgumentHint(name="username", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="privilege", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="database", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String user, String privilege, String database, String table) {
        if (database == null) {
            Preconditions.checkState(table == null, "database must be set if privilege is granted at table's granularity.");
            this.getPrivilegedCatalog().grantPrivilegeOnCatalog(user, PrivilegeType.valueOf(privilege));
            return new String[]{String.format("User %s is granted with privilege %s on the catalog.", user, privilege)};
        }
        if (table == null) {
            this.getPrivilegedCatalog().grantPrivilegeOnDatabase(user, database, PrivilegeType.valueOf(privilege));
            return new String[]{String.format("User %s is granted with privilege %s on database %s.", user, privilege, database)};
        }
        Identifier identifier = Identifier.create(database, table);
        this.getPrivilegedCatalog().grantPrivilegeOnTable(user, identifier, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is granted with privilege %s on table %s.", user, privilege, identifier)};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

