/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class RollbackToProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "rollback_to";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tag", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="snapshot_id", type=@DataTypeHint(value="BIGINT"), isOptional=true)})
    @DataTypeHint(value="ROW<previous_snapshot_id BIGINT, current_snapshot_id BIGINT>")
    public Row[] call(ProcedureContext procedureContext, String tableId, String tagName, Long snapshotId) throws Catalog.TableNotExistException {
        long rollbackSnapshotId;
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        FileStore<?> store = ((FileStoreTable)table).store();
        Snapshot latestSnapshot = store.snapshotManager().latestSnapshot();
        Preconditions.checkNotNull(latestSnapshot, "Latest snapshot is null, can not rollback.");
        if (!StringUtils.isNullOrWhitespaceOnly(tagName)) {
            table.rollbackTo(tagName);
            rollbackSnapshotId = store.newTagManager().getOrThrow(tagName).trimToSnapshot().id();
        } else {
            table.rollbackTo(snapshotId);
            rollbackSnapshotId = snapshotId;
        }
        return new Row[]{Row.of((Object[])new Object[]{latestSnapshot.id(), rollbackSnapshotId})};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

