/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.RemoveUnexistingFilesAction;
import org.apache.paimon.flink.procedure.ProcedureBase;

public class RemoveUnexistingFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_unexisting_files";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="dry_run", type=@DataTypeHint(value="BOOLEAN"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="INT"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, @Nullable Boolean dryRun, @Nullable Integer parallelism) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        RemoveUnexistingFilesAction action = new RemoveUnexistingFilesAction(databaseName, tableName, this.catalog.options());
        if (Boolean.TRUE.equals(dryRun)) {
            action.dryRun();
        }
        if (parallelism != null) {
            action.withParallelism(parallelism);
        }
        action.withStreamExecutionEnvironment(procedureContext.getExecutionEnvironment());
        ArrayList result = new ArrayList();
        try (CloseableIterator it = action.buildDataStream().executeAndCollect("Remove Unexisting Files : " + tableName);){
            it.forEachRemaining(result::add);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

