/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.service.QueryService;
import org.apache.paimon.table.Table;

public class QueryServiceProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "query_service";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="INT"))})
    public String[] call(ProcedureContext procedureContext, String tableId, Integer parallelism) throws Exception {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        StreamExecutionEnvironment env = procedureContext.getExecutionEnvironment();
        QueryService.build(env, table, parallelism);
        return this.execute(env, IDENTIFIER);
    }
}

