/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Map;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.MergeIntoAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.Preconditions;

public class MergeIntoProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "merge_into";

    @ProcedureHint(argument={@ArgumentHint(name="target_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="target_alias", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="source_sqls", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="source_table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="merge_condition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="matched_upsert_condition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="matched_upsert_setting", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="not_matched_insert_condition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="not_matched_insert_values", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="matched_delete_condition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="not_matched_by_source_upsert_condition", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="not_matched_by_source_upsert_setting", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="not_matched_by_source_delete_condition", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String targetTableId, String targetAlias, String sourceSqls, String sourceTable, String mergeCondition, String matchedUpsertCondition, String matchedUpsertSetting, String notMatchedInsertCondition, String notMatchedInsertValues, String matchedDeleteCondition, String notMatchedBySourceUpsertCondition, String notMatchedBySourceUpsertSetting, String notMatchedBySourceDeleteCondition) {
        String values;
        String condition;
        targetAlias = this.notnull(targetAlias);
        sourceSqls = this.notnull(sourceSqls);
        sourceTable = this.notnull(sourceTable);
        mergeCondition = this.notnull(mergeCondition);
        matchedUpsertCondition = this.notnull(matchedUpsertCondition);
        matchedUpsertSetting = this.notnull(matchedUpsertSetting);
        notMatchedInsertCondition = this.notnull(notMatchedInsertCondition);
        notMatchedInsertValues = this.notnull(notMatchedInsertValues);
        matchedDeleteCondition = this.notnull(matchedDeleteCondition);
        notMatchedBySourceUpsertCondition = this.notnull(notMatchedBySourceUpsertCondition);
        notMatchedBySourceUpsertSetting = this.notnull(notMatchedBySourceUpsertSetting);
        notMatchedBySourceDeleteCondition = this.notnull(notMatchedBySourceDeleteCondition);
        Map<String, String> catalogOptions = this.catalog.options();
        Identifier identifier = Identifier.fromString(targetTableId);
        MergeIntoAction action = new MergeIntoAction(identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions);
        action.withTargetAlias(this.nullable(targetAlias));
        if (!sourceSqls.isEmpty()) {
            action.withSourceSqls(sourceSqls.split(";"));
        }
        Preconditions.checkArgument(!sourceTable.isEmpty(), "Must specify source table.");
        action.withSourceTable(sourceTable);
        Preconditions.checkArgument(!mergeCondition.isEmpty(), "Must specify merge condition.");
        action.withMergeCondition(mergeCondition);
        if (!matchedUpsertCondition.isEmpty() || !matchedUpsertSetting.isEmpty()) {
            condition = this.nullable(matchedUpsertCondition);
            String setting = this.nullable(matchedUpsertSetting);
            Preconditions.checkNotNull(setting, "matched-upsert must set the 'matchedUpsertSetting' argument");
            action.withMatchedUpsert(condition, setting);
        }
        if (!notMatchedInsertCondition.isEmpty() || !notMatchedInsertValues.isEmpty()) {
            condition = this.nullable(notMatchedInsertCondition);
            values = this.nullable(notMatchedInsertValues);
            Preconditions.checkNotNull(values, "not-matched-insert must set the 'notMatchedInsertValues' argument");
            action.withNotMatchedInsert(condition, values);
        }
        if (!matchedDeleteCondition.isEmpty()) {
            action.withMatchedDelete(matchedDeleteCondition);
        }
        if (!notMatchedBySourceUpsertCondition.isEmpty() || !notMatchedBySourceUpsertSetting.isEmpty()) {
            condition = this.nullable(notMatchedBySourceUpsertCondition);
            values = this.nullable(notMatchedBySourceUpsertSetting);
            Preconditions.checkArgument(!"*".equals(values), "not-matched-by-source-upsert does not support setting notMatchedBySourceUpsertSetting to *.");
            action.withNotMatchedBySourceUpsert(condition, values);
        }
        if (!notMatchedBySourceDeleteCondition.isEmpty()) {
            action.withNotMatchedBySourceDelete(notMatchedBySourceDeleteCondition);
        }
        action.withStreamExecutionEnvironment(procedureContext.getExecutionEnvironment());
        action.validate();
        DataStream<RowData> dataStream = action.buildDataStream();
        TableResult tableResult = action.batchSink(dataStream);
        JobClient jobClient = (JobClient)tableResult.getJobClient().get();
        return this.execute(procedureContext, jobClient);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

