/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.Serializable;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshBlacklist
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RefreshBlacklist.class);
    private final List<Pair<Long, Long>> timePeriodsBlacklist;
    private long nextBlacklistCheckTime;

    public RefreshBlacklist(List<Pair<Long, Long>> timePeriodsBlacklist) {
        this.timePeriodsBlacklist = timePeriodsBlacklist;
        this.nextBlacklistCheckTime = -1L;
    }

    @Nullable
    public static RefreshBlacklist create(String blacklist) {
        List<Pair<Long, Long>> timePeriodsBlacklist = RefreshBlacklist.parseTimePeriodsBlacklist(blacklist);
        if (timePeriodsBlacklist.isEmpty()) {
            return null;
        }
        return new RefreshBlacklist(timePeriodsBlacklist);
    }

    private static List<Pair<Long, Long>> parseTimePeriodsBlacklist(String blacklist) {
        if (StringUtils.isNullOrWhitespaceOnly(blacklist)) {
            return Collections.emptyList();
        }
        String[] timePeriods = blacklist.split(",");
        ArrayList<Pair<Long, Long>> result = new ArrayList<Pair<Long, Long>>();
        for (String period : timePeriods) {
            long right;
            String[] times = period.split("->");
            if (times.length != 2) {
                throw new IllegalArgumentException(String.format("Incorrect time periods format: [%s].", blacklist));
            }
            long left = RefreshBlacklist.parseToMillis(times[0]);
            if (left > (right = RefreshBlacklist.parseToMillis(times[1]))) {
                throw new IllegalArgumentException(String.format("Incorrect time period: [%s->%s].", times[0], times[1]));
            }
            result.add(Pair.of(left, right));
        }
        return result;
    }

    private static long parseToMillis(String dateTime) {
        try {
            return DateTimeUtils.parseTimestampData(dateTime + ":00", 3, TimeZone.getDefault()).getMillisecond();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Date time format error: [%s].", dateTime), e);
        }
    }

    public boolean canRefresh() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < this.nextBlacklistCheckTime) {
            return false;
        }
        Pair<Long, Long> selectedPeriod = null;
        for (Pair<Long, Long> period : this.timePeriodsBlacklist) {
            if (period.getLeft() > currentTimeMillis || currentTimeMillis > period.getRight()) continue;
            selectedPeriod = period;
            break;
        }
        if (selectedPeriod != null) {
            LOG.info("Current time {} is in black list {}-{}, so try to refresh cache next time.", new Object[]{currentTimeMillis, selectedPeriod.getLeft(), selectedPeriod.getRight()});
            this.nextBlacklistCheckTime = selectedPeriod.getRight() + 1L;
            return false;
        }
        return true;
    }

    public long nextBlacklistCheckTime() {
        return this.nextBlacklistCheckTime;
    }
}

