/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.lookup.DynamicPartitionLevelLoader;
import org.apache.paimon.flink.lookup.DynamicPartitionNumberLoader;
import org.apache.paimon.flink.lookup.StaticPartitionLoader;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;

public abstract class PartitionLoader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String MAX_PT = "max_pt()";
    protected static final String MAX_TWO_PT = "max_two_pt()";
    protected final FileStoreTable table;
    private final RowDataToObjectArrayConverter partitionConverter;
    protected transient List<BinaryRow> partitions;

    protected PartitionLoader(FileStoreTable table) {
        this.table = table;
        this.partitionConverter = new RowDataToObjectArrayConverter(table.rowType().project(table.partitionKeys()));
    }

    public void open() {
        this.partitions = new ArrayList<BinaryRow>();
    }

    public List<BinaryRow> partitions() {
        return this.partitions;
    }

    public void addPartitionKeysTo(List<String> joinKeys, List<String> projectFields) {
        List<String> partitionKeys = this.table.partitionKeys();
        Preconditions.checkArgument(joinKeys.stream().noneMatch(partitionKeys::contains), "Currently, Paimon lookup table with partitions does not support partition keys in join keys.");
        joinKeys.addAll(partitionKeys);
        partitionKeys.stream().filter(k -> !projectFields.contains(k)).forEach(projectFields::add);
    }

    public Predicate createSpecificPartFilter() {
        Predicate partFilter = null;
        for (BinaryRow partition : this.partitions) {
            if (partFilter == null) {
                partFilter = this.createSinglePartFilter(partition);
                continue;
            }
            partFilter = PredicateBuilder.or(partFilter, this.createSinglePartFilter(partition));
        }
        return partFilter;
    }

    private Predicate createSinglePartFilter(BinaryRow partition) {
        RowType rowType = this.table.rowType();
        List<String> partitionKeys = this.table.partitionKeys();
        Object[] partitionSpec = this.partitionConverter.convert(partition);
        HashMap<String, Object> partitionMap = new HashMap<String, Object>(partitionSpec.length);
        for (int i = 0; i < partitionSpec.length; ++i) {
            partitionMap.put(partitionKeys.get(i), partitionSpec[i]);
        }
        return PartitionPredicate.createPartitionPredicate(rowType, partitionMap);
    }

    public abstract boolean checkRefresh();

    @Nullable
    public static PartitionLoader of(FileStoreTable table) {
        Options options = Options.fromMap(table.options());
        String scanPartitions = options.get(FlinkConnectorOptions.SCAN_PARTITIONS);
        if (scanPartitions == null) {
            return null;
        }
        Preconditions.checkArgument(!table.partitionKeys().isEmpty(), "{} is not supported for non-partitioned table.", FlinkConnectorOptions.SCAN_PARTITIONS.key());
        int maxPartitionNum = -1;
        switch (scanPartitions.toLowerCase()) {
            case "max_pt()": {
                maxPartitionNum = 1;
                break;
            }
            case "max_two_pt()": {
                maxPartitionNum = 2;
            }
        }
        Duration refresh = options.get(FlinkConnectorOptions.LOOKUP_DYNAMIC_PARTITION_REFRESH_INTERVAL);
        if (maxPartitionNum == -1) {
            if (scanPartitions.contains(MAX_PT)) {
                return new DynamicPartitionLevelLoader(table, refresh, ParameterUtils.parseCommaSeparatedKeyValues(scanPartitions));
            }
            return new StaticPartitionLoader(table, ParameterUtils.getPartitions(scanPartitions.split(";")));
        }
        return new DynamicPartitionNumberLoader(table, refresh, maxPartitionNum);
    }
}

