/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.FollowUpScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionDiffFollowUpScanner
implements FollowUpScanner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionDiffFollowUpScanner.class);

    @Override
    public boolean shouldScanSnapshot(Snapshot snapshot) {
        if (snapshot.commitKind() == Snapshot.CommitKind.COMPACT) {
            return true;
        }
        LOG.debug("Next snapshot id {} is not COMPACT, but is {}, check next one.", (Object)snapshot.id(), (Object)snapshot.commitKind());
        return false;
    }

    @Override
    public SnapshotReader.Plan scan(Snapshot snapshot, SnapshotReader snapshotReader) {
        return snapshotReader.withMode(ScanMode.DELTA).withSnapshot(snapshot).readChanges();
    }
}

