/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.paimon.flink.compact.changelog.ChangelogCompactTask;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.utils.SerializationUtils;

public class ChangelogCompactTaskSerializer
implements SimpleVersionedSerializer<ChangelogCompactTask> {
    private static final int CURRENT_VERSION = 2;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(ChangelogCompactTask obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        this.serialize(obj, view);
        return out.toByteArray();
    }

    public ChangelogCompactTask deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(version, view);
    }

    private void serialize(ChangelogCompactTask task, DataOutputView view) throws IOException {
        view.writeLong(task.checkpointId());
        SerializationUtils.serializeBinaryRow(task.partition(), view);
        view.writeInt(task.totalBuckets());
        this.serializeMap(task.newFileChangelogFiles(), view);
        this.serializeMap(task.compactChangelogFiles(), view);
    }

    private ChangelogCompactTask deserialize(int version, DataInputView view) throws IOException {
        if (version != this.getVersion()) {
            throw new RuntimeException("Can not deserialize version: " + version);
        }
        return new ChangelogCompactTask(view.readLong(), SerializationUtils.deserializeBinaryRow(view), view.readInt(), this.deserializeMap(view), this.deserializeMap(view));
    }

    private void serializeMap(Map<Integer, List<DataFileMeta>> map, DataOutputView view) throws IOException {
        view.writeInt(map.size());
        for (Map.Entry<Integer, List<DataFileMeta>> entry : map.entrySet()) {
            view.writeInt(entry.getKey());
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("serialize error. no value for bucket-" + entry.getKey());
            }
            this.dataFileSerializer.serializeList(entry.getValue(), view);
        }
    }

    private Map<Integer, List<DataFileMeta>> deserializeMap(DataInputView view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, List<DataFileMeta>> map = new HashMap<Integer, List<DataFileMeta>>(size);
        for (int i = 0; i < size; ++i) {
            map.put(view.readInt(), this.dataFileSerializer.deserializeList(view));
        }
        return map;
    }
}

