/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone.schema;

import java.util.Map;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.clone.schema.CloneSchemaInfo;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;

public class ClonePaimonSchemaFunction
extends ProcessFunction<Tuple2<Identifier, Identifier>, CloneSchemaInfo> {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> sourceCatalogConfig;
    private final Map<String, String> targetCatalogConfig;
    private transient Catalog sourceCatalog;
    private transient Catalog targetCatalog;

    public ClonePaimonSchemaFunction(Map<String, String> sourceCatalogConfig, Map<String, String> targetCatalogConfig) {
        this.sourceCatalogConfig = sourceCatalogConfig;
        this.targetCatalogConfig = targetCatalogConfig;
    }

    public void open(OpenContext openContext) throws Exception {
        this.open(new Configuration());
    }

    public void open(Configuration conf) throws Exception {
        this.sourceCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.sourceCatalogConfig));
        this.targetCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.targetCatalogConfig));
    }

    public void processElement(Tuple2<Identifier, Identifier> tuple, ProcessFunction.Context context, Collector<CloneSchemaInfo> collector) throws Exception {
        this.targetCatalog.createDatabase(((Identifier)tuple.f1).getDatabaseName(), true);
        Table sourceTable = this.sourceCatalog.getTable((Identifier)tuple.f0);
        Schema.Builder builder = Schema.newBuilder();
        sourceTable.rowType().getFields().forEach(f -> builder.column(f.name(), f.type(), f.description(), f.defaultValue()));
        builder.partitionKeys(sourceTable.partitionKeys());
        builder.primaryKey(sourceTable.primaryKeys());
        sourceTable.options().forEach((k, v) -> {
            if (k.equalsIgnoreCase(CoreOptions.BUCKET.key()) || k.equalsIgnoreCase(CoreOptions.PATH.key())) {
                return;
            }
            builder.option((String)k, (String)v);
        });
        if (sourceTable.primaryKeys().isEmpty()) {
            if (sourceTable.options().containsKey(CoreOptions.BUCKET_KEY.key())) {
                builder.option(CoreOptions.BUCKET.key(), sourceTable.options().get(CoreOptions.BUCKET.key()));
                builder.option(CoreOptions.BUCKET_KEY.key(), sourceTable.options().get(CoreOptions.BUCKET_KEY.key()));
            }
        } else {
            builder.option(CoreOptions.BUCKET.key(), "-2");
        }
        this.targetCatalog.createTable((Identifier)tuple.f1, builder.build(), true);
        CloneSchemaInfo cloneSchemaInfo = new CloneSchemaInfo(tuple, true);
        collector.collect((Object)cloneSchemaInfo);
    }

    public void close() throws Exception {
        super.close();
        if (this.sourceCatalog != null) {
            this.sourceCatalog.close();
        }
        if (this.targetCatalog != null) {
            this.targetCatalog.close();
        }
    }
}

