/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone.files;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.clone.HivePartitionFiles;
import org.apache.paimon.utils.SerializationUtils;

public class CloneFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Identifier identifier;
    private final byte[] partition;
    private final Path path;
    private final long fileSize;
    private final String format;

    public CloneFileInfo(Identifier identifier, BinaryRow partition, Path path, long fileSize, String format) {
        this.identifier = identifier;
        this.partition = SerializationUtils.serializeBinaryRow(partition);
        this.path = path;
        this.fileSize = fileSize;
        this.format = format;
    }

    public Identifier identifier() {
        return this.identifier;
    }

    public BinaryRow partition() {
        return SerializationUtils.deserializeBinaryRow(this.partition);
    }

    public Path path() {
        return this.path;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public String format() {
        return this.format;
    }

    public static List<CloneFileInfo> fromHive(Identifier identifier, HivePartitionFiles files) {
        ArrayList<CloneFileInfo> result = new ArrayList<CloneFileInfo>();
        for (int i = 0; i < files.paths().size(); ++i) {
            Path path = files.paths().get(i);
            long fileSize = files.fileSizes().get(i);
            result.add(new CloneFileInfo(identifier, files.partition(), path, fileSize, files.format()));
        }
        return result;
    }
}

