/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.RollbackToTimestampAction;

public class RollbackToTimestampActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "rollback_to_timestamp";
    private static final String TIMESTAMP = "timestamp";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        RollbackToTimestampAction action = new RollbackToTimestampAction(params.getRequired("database"), params.getRequired("table"), Long.parseLong(params.getRequired(TIMESTAMP)), this.catalogConfigMap(params));
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"rollback_to_timestamp\" roll back a table to a specific timestamp.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  rollback_to \\\n--warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n--timestamp <timestamp_string>");
        System.out.println("  <timestamp_string> can be a long value representing a timestamp.");
        System.out.println();
    }
}

