/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.flink.service.QueryService;

public class QueryServiceActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "query_service";
    public static final String PARALLELISM = "parallelism";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        final Map<String, String> tableConfig = this.optionalConfigMap(params, "table_conf");
        String parallStr = params.get(PARALLELISM);
        final int parallelism = parallStr == null ? 1 : Integer.parseInt(parallStr);
        TableActionBase action = new TableActionBase(params.getRequired("database"), params.getRequired("table"), catalogConfig){

            @Override
            public void run() throws Exception {
                QueryService.build(this.env, this.table.copy(tableConfig), parallelism);
                this.execute("Query Service job");
            }
        };
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"query-service\" runs a dedicated job starting query service for a table.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  query-service \\\n--warehouse <warehouse-path> \\\n--database <database-name> \\\n--table <table-name> \\\n--parallelism <parallelism> \\\n[--catalog_conf <key>=<value> [--catalog_conf <key>=<value> ...]] \\\n[--table_conf <key>=<value> [--table_conf <key>=<value> ...]]");
    }
}

