/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ExpirePartitionsAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class ExpirePartitionsActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "expire_partitions";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        String expireStrategy = params.get("expire_strategy");
        String timestampPattern = params.get("timestamp_pattern");
        return Optional.of(new ExpirePartitionsAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params), this.optionalConfigMap(params, "table_conf"), params.getRequired("expiration_time"), params.getRequired("timestamp_formatter"), timestampPattern, expireStrategy));
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"expire_partitions\" expire table partitions by name.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  expire_partitions \\\n--warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n--tag_name <tag_name> \\\n--expiration_time <expiration_time> \\\n--timestamp_formatter <timestamp_formatter> \\\n[--timestamp_pattern <timestamp_pattern>] \\\n[--expire_strategy <expire_strategy>]");
        System.out.println();
    }
}

