/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;

public class DropPartitionAction
extends TableActionBase {
    private final List<Map<String, String>> partitions;
    private final BatchTableCommit commit;

    public DropPartitionAction(String databaseName, String tableName, List<Map<String, String>> partitions, Map<String, String> catalogConfig) {
        super(databaseName, tableName, catalogConfig);
        if (!(this.table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only FileStoreTable supports drop-partition action. The table type is '%s'.", this.table.getClass().getName()));
        }
        this.partitions = partitions;
        this.commit = this.table.newBatchWriteBuilder().newCommit();
    }

    @Override
    public void run() throws Exception {
        this.commit.truncatePartitions(this.partitions);
    }
}

