/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.utils.TimeUtils;

public abstract class CreateOrReplaceTagActionFactory
implements ActionFactory {
    private static final String TAG_NAME = "tag_name";
    private static final String SNAPSHOT = "snapshot";
    private static final String TIME_RETAINED = "time_retained";

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        String tagName = params.getRequired(TAG_NAME);
        Long snapshot = null;
        if (params.has(SNAPSHOT)) {
            snapshot = Long.parseLong(params.get(SNAPSHOT));
        }
        Duration timeRetained = null;
        if (params.has(TIME_RETAINED)) {
            timeRetained = TimeUtils.parseDuration(params.get(TIME_RETAINED));
        }
        return Optional.of(this.createOrReplaceTagAction(params.getRequired("database"), params.getRequired("table"), catalogConfig, tagName, snapshot, timeRetained));
    }

    abstract Action createOrReplaceTagAction(String var1, String var2, Map<String, String> var3, String var4, Long var5, Duration var6);
}

