/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.utils.StringUtils;

public class CloneActionFactory
implements ActionFactory {
    private static final String IDENTIFIER = "clone";
    private static final String TARGET_WAREHOUSE = "target_warehouse";
    private static final String TARGET_DATABASE = "target_database";
    private static final String TARGET_TABLE = "target_table";
    private static final String TARGET_CATALOG_CONF = "target_catalog_conf";
    private static final String PARALLELISM = "parallelism";
    private static final String WHERE = "where";
    private static final String INCLUDED_TABLES = "included_tables";
    private static final String EXCLUDED_TABLES = "excluded_tables";
    private static final String CLONE_FROM = "clone_from";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Map<String, String> catalogConfig = this.catalogConfigMap(params);
        HashMap<String, String> targetCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(params, TARGET_CATALOG_CONF));
        String targetWarehouse = params.get(TARGET_WAREHOUSE);
        if (targetWarehouse != null && !targetCatalogConfig.containsKey("warehouse")) {
            targetCatalogConfig.put("warehouse", targetWarehouse);
        }
        String parallelism = params.get(PARALLELISM);
        String includedTablesStr = params.get(INCLUDED_TABLES);
        List<String> includedTables = StringUtils.isNullOrWhitespaceOnly(includedTablesStr) ? null : Arrays.asList(StringUtils.split(includedTablesStr, ","));
        String excludedTablesStr = params.get(EXCLUDED_TABLES);
        List<String> excludedTables = StringUtils.isNullOrWhitespaceOnly(excludedTablesStr) ? null : Arrays.asList(StringUtils.split(excludedTablesStr, ","));
        String cloneFrom = params.get(CLONE_FROM);
        if (StringUtils.isNullOrWhitespaceOnly(cloneFrom)) {
            cloneFrom = "hive";
        }
        CloneAction cloneAction = new CloneAction(params.get("database"), params.get("table"), catalogConfig, params.get(TARGET_DATABASE), params.get(TARGET_TABLE), targetCatalogConfig, parallelism == null ? null : Integer.valueOf(Integer.parseInt(parallelism)), params.get(WHERE), includedTables, excludedTables, cloneFrom);
        return Optional.of(cloneAction);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"clone\" clones the source files and migrate them to paimon table.");
        System.out.println();
    }
}

