/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.CachingCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.flink.clone.CloneHiveTableUtils;
import org.apache.paimon.flink.clone.ClonePaimonTableUtils;
import org.apache.paimon.hive.HiveCatalog;

public class CloneAction
extends ActionBase {
    private final Map<String, String> sourceCatalogConfig;
    private final String sourceDatabase;
    private final String sourceTableName;
    private final Map<String, String> targetCatalogConfig;
    private final String targetDatabase;
    private final String targetTableName;
    private final int parallelism;
    @Nullable
    private final String whereSql;
    @Nullable
    private final List<String> includedTables;
    @Nullable
    private final List<String> excludedTables;
    private final String cloneFrom;

    public CloneAction(String sourceDatabase, String sourceTableName, Map<String, String> sourceCatalogConfig, String targetDatabase, String targetTableName, Map<String, String> targetCatalogConfig, @Nullable Integer parallelism, @Nullable String whereSql, @Nullable List<String> includedTables, @Nullable List<String> excludedTables, String cloneFrom) {
        super(sourceCatalogConfig);
        if (cloneFrom.equalsIgnoreCase("hive")) {
            Catalog sourceCatalog = this.catalog;
            if (sourceCatalog instanceof CachingCatalog) {
                sourceCatalog = ((CachingCatalog)sourceCatalog).wrapped();
            }
            if (!(sourceCatalog instanceof HiveCatalog)) {
                throw new UnsupportedOperationException("Only support clone hive tables using HiveCatalog, but current source catalog is " + sourceCatalog.getClass().getName());
            }
        }
        this.sourceDatabase = sourceDatabase;
        this.sourceTableName = sourceTableName;
        this.sourceCatalogConfig = sourceCatalogConfig;
        this.targetDatabase = targetDatabase;
        this.targetTableName = targetTableName;
        this.targetCatalogConfig = targetCatalogConfig;
        this.parallelism = parallelism == null ? this.env.getParallelism() : parallelism.intValue();
        this.whereSql = whereSql;
        this.includedTables = includedTables;
        this.excludedTables = excludedTables;
        this.cloneFrom = cloneFrom;
    }

    @Override
    public void build() throws Exception {
        switch (this.cloneFrom) {
            case "hive": {
                CloneHiveTableUtils.build(this.env, this.catalog, this.sourceDatabase, this.sourceTableName, this.sourceCatalogConfig, this.targetDatabase, this.targetTableName, this.targetCatalogConfig, this.parallelism, this.whereSql, this.includedTables, this.excludedTables);
                break;
            }
            case "paimon": {
                ClonePaimonTableUtils.build(this.env, this.catalog, this.sourceDatabase, this.sourceTableName, this.sourceCatalogConfig, this.targetDatabase, this.targetTableName, this.targetCatalogConfig, this.parallelism, this.whereSql, this.includedTables, this.excludedTables);
            }
        }
    }

    @Override
    public void run() throws Exception {
        this.build();
        this.execute("Clone job");
    }
}

