/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.FlinkRowWrapper;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.utils.TypeUtils;

public class PredicateConverter
implements ExpressionVisitor<Predicate> {
    private final PredicateBuilder builder;
    private static final Pattern BEGIN_PATTERN = Pattern.compile("([^%]+)%");

    public PredicateConverter(RowType type) {
        this(new PredicateBuilder(LogicalTypeConversion.toDataType(type)));
    }

    public PredicateConverter(PredicateBuilder builder) {
        this.builder = builder;
    }

    public Predicate visit(CallExpression call) {
        FunctionDefinition func = call.getFunctionDefinition();
        List children = call.getChildren();
        if (func == BuiltInFunctionDefinitions.AND) {
            return PredicateBuilder.and((Predicate)((Expression)children.get(0)).accept((ExpressionVisitor)this), (Predicate)((Expression)children.get(1)).accept((ExpressionVisitor)this));
        }
        if (func == BuiltInFunctionDefinitions.OR) {
            return PredicateBuilder.or((Predicate)((Expression)children.get(0)).accept((ExpressionVisitor)this), (Predicate)((Expression)children.get(1)).accept((ExpressionVisitor)this));
        }
        if (func == BuiltInFunctionDefinitions.EQUALS) {
            return this.visitBiFunction(children, this.builder::equal, this.builder::equal);
        }
        if (func == BuiltInFunctionDefinitions.NOT_EQUALS) {
            return this.visitBiFunction(children, this.builder::notEqual, this.builder::notEqual);
        }
        if (func == BuiltInFunctionDefinitions.GREATER_THAN) {
            return this.visitBiFunction(children, this.builder::greaterThan, this.builder::lessThan);
        }
        if (func == BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL) {
            return this.visitBiFunction(children, this.builder::greaterOrEqual, this.builder::lessOrEqual);
        }
        if (func == BuiltInFunctionDefinitions.LESS_THAN) {
            return this.visitBiFunction(children, this.builder::lessThan, this.builder::greaterThan);
        }
        if (func == BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL) {
            return this.visitBiFunction(children, this.builder::lessOrEqual, this.builder::greaterOrEqual);
        }
        if (func == BuiltInFunctionDefinitions.IN) {
            FieldReferenceExpression fieldRefExpr = this.extractFieldReference((Expression)children.get(0)).orElseThrow(UnsupportedExpression::new);
            ArrayList<Object> literals = new ArrayList<Object>();
            for (int i = 1; i < children.size(); ++i) {
                literals.add(this.extractLiteral(fieldRefExpr.getOutputDataType(), (Expression)children.get(i)));
            }
            return this.builder.in(this.builder.indexOf(fieldRefExpr.getName()), literals);
        }
        if (func == BuiltInFunctionDefinitions.IS_NULL) {
            return this.extractFieldReference((Expression)children.get(0)).map(FieldReferenceExpression::getName).map(this.builder::indexOf).map(this.builder::isNull).orElseThrow(UnsupportedExpression::new);
        }
        if (func == BuiltInFunctionDefinitions.IS_NOT_NULL) {
            return this.extractFieldReference((Expression)children.get(0)).map(FieldReferenceExpression::getName).map(this.builder::indexOf).map(this.builder::isNotNull).orElseThrow(UnsupportedExpression::new);
        }
        if (func == BuiltInFunctionDefinitions.BETWEEN) {
            FieldReferenceExpression fieldRefExpr = this.extractFieldReference((Expression)children.get(0)).orElseThrow(UnsupportedExpression::new);
            return this.builder.between(this.builder.indexOf(fieldRefExpr.getName()), children.get(1), children.get(2));
        }
        if (func == BuiltInFunctionDefinitions.LIKE) {
            FieldReferenceExpression fieldRefExpr = this.extractFieldReference((Expression)children.get(0)).orElseThrow(UnsupportedExpression::new);
            if (fieldRefExpr.getOutputDataType().getLogicalType().getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) {
                Matcher beginMatcher;
                String sqlPattern = Objects.requireNonNull(this.extractLiteral(fieldRefExpr.getOutputDataType(), (Expression)children.get(1))).toString();
                String escape = children.size() <= 2 ? null : Objects.requireNonNull(this.extractLiteral(fieldRefExpr.getOutputDataType(), (Expression)children.get(2))).toString();
                String escapedSqlPattern = sqlPattern;
                boolean allowQuick = false;
                if (escape == null && !sqlPattern.contains("_")) {
                    allowQuick = true;
                } else if (escape != null) {
                    if (escape.length() != 1) {
                        throw new UnsupportedExpression();
                    }
                    char escapeChar = escape.charAt(0);
                    boolean matched = true;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < sqlPattern.length() && matched; ++i) {
                        char c = sqlPattern.charAt(i);
                        if (c == escapeChar) {
                            if (i == sqlPattern.length() - 1) {
                                throw new UnsupportedExpression();
                            }
                            char nextChar = sqlPattern.charAt(i + 1);
                            if (nextChar == '%') {
                                matched = false;
                                continue;
                            }
                            if (nextChar == '_' || nextChar == escapeChar) {
                                sb.append(nextChar);
                                ++i;
                                continue;
                            }
                            throw new UnsupportedExpression();
                        }
                        if (c == '_') {
                            matched = false;
                            continue;
                        }
                        sb.append(c);
                    }
                    if (matched) {
                        allowQuick = true;
                        escapedSqlPattern = sb.toString();
                    }
                }
                if (allowQuick && (beginMatcher = BEGIN_PATTERN.matcher(escapedSqlPattern)).matches()) {
                    return this.builder.startsWith(this.builder.indexOf(fieldRefExpr.getName()), BinaryString.fromString(beginMatcher.group(1)));
                }
            }
        } else {
            if (func == BuiltInFunctionDefinitions.IS_TRUE) {
                FieldReferenceExpression fieldRefExpr = this.extractFieldReference((Expression)children.get(0)).orElseThrow(UnsupportedExpression::new);
                return this.builder.equal(this.builder.indexOf(fieldRefExpr.getName()), Boolean.TRUE);
            }
            if (func == BuiltInFunctionDefinitions.IS_FALSE) {
                FieldReferenceExpression fieldRefExpr = this.extractFieldReference((Expression)children.get(0)).orElseThrow(UnsupportedExpression::new);
                return this.builder.equal(this.builder.indexOf(fieldRefExpr.getName()), Boolean.FALSE);
            }
        }
        throw new UnsupportedExpression();
    }

    private Predicate visitBiFunction(List<Expression> children, BiFunction<Integer, Object, Predicate> visit1, BiFunction<Integer, Object, Predicate> visit2) {
        Optional<FieldReferenceExpression> fieldRefExpr = this.extractFieldReference(children.get(0));
        if (fieldRefExpr.isPresent()) {
            Object literal = this.extractLiteral(fieldRefExpr.get().getOutputDataType(), children.get(1));
            return visit1.apply(this.builder.indexOf(fieldRefExpr.get().getName()), literal);
        }
        fieldRefExpr = this.extractFieldReference(children.get(1));
        if (fieldRefExpr.isPresent()) {
            Object literal = this.extractLiteral(fieldRefExpr.get().getOutputDataType(), children.get(0));
            return visit2.apply(this.builder.indexOf(fieldRefExpr.get().getName()), literal);
        }
        throw new UnsupportedExpression();
    }

    private Optional<FieldReferenceExpression> extractFieldReference(Expression expression) {
        if (expression instanceof FieldReferenceExpression) {
            return Optional.of((FieldReferenceExpression)expression);
        }
        return Optional.empty();
    }

    private Object extractLiteral(DataType expectedType, Expression expression) {
        LogicalType expectedLogicalType = expectedType.getLogicalType();
        if (!this.supportsPredicate(expectedLogicalType)) {
            throw new UnsupportedExpression();
        }
        if (expression instanceof ValueLiteralExpression) {
            ValueLiteralExpression valueExpression = (ValueLiteralExpression)expression;
            if (valueExpression.isNull()) {
                return null;
            }
            DataType actualType = valueExpression.getOutputDataType();
            LogicalType actualLogicalType = actualType.getLogicalType();
            Optional valueOpt = valueExpression.getValueAs(actualType.getConversionClass());
            if (valueOpt.isPresent()) {
                Object value = valueOpt.get();
                if (actualLogicalType.getTypeRoot().equals((Object)expectedLogicalType.getTypeRoot())) {
                    return FlinkRowWrapper.fromFlinkObject(DataStructureConverters.getConverter((DataType)expectedType).toInternalOrNull(value), expectedLogicalType);
                }
                if (LogicalTypeCasts.supportsImplicitCast((LogicalType)actualLogicalType, (LogicalType)expectedLogicalType)) {
                    try {
                        return TypeUtils.castFromString(value.toString(), LogicalTypeConversion.toDataType(expectedLogicalType));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        throw new UnsupportedExpression();
    }

    private boolean supportsPredicate(LogicalType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return true;
            }
        }
        return false;
    }

    public Predicate visit(ValueLiteralExpression valueLiteralExpression) {
        throw new UnsupportedExpression();
    }

    public Predicate visit(FieldReferenceExpression fieldReferenceExpression) {
        throw new UnsupportedExpression();
    }

    public Predicate visit(TypeLiteralExpression typeLiteralExpression) {
        throw new UnsupportedExpression();
    }

    public Predicate visit(Expression expression) {
        throw new UnsupportedExpression();
    }

    public static Optional<Predicate> convert(RowType rowType, ResolvedExpression filter) {
        try {
            return Optional.ofNullable((Predicate)filter.accept((ExpressionVisitor)new PredicateConverter(rowType)));
        }
        catch (UnsupportedExpression e) {
            return Optional.empty();
        }
    }

    public static class UnsupportedExpression
    extends RuntimeException {
    }
}

