/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VariantType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.VarCharType;

public class LogicalTypeToDataType
extends LogicalTypeDefaultVisitor<DataType> {
    private final AtomicInteger currentHighestFieldId;

    public LogicalTypeToDataType(AtomicInteger currentHighestFieldId) {
        this.currentHighestFieldId = currentHighestFieldId;
    }

    public DataType visit(org.apache.flink.table.types.logical.CharType charType) {
        return new CharType(charType.isNullable(), charType.getLength());
    }

    public DataType visit(org.apache.flink.table.types.logical.VarCharType varCharType) {
        return new VarCharType(varCharType.isNullable(), varCharType.getLength());
    }

    public DataType visit(BooleanType booleanType) {
        return new org.apache.paimon.types.BooleanType(booleanType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.BinaryType binaryType) {
        return new BinaryType(binaryType.isNullable(), binaryType.getLength());
    }

    public DataType visit(VarBinaryType varBinaryType) {
        return new org.apache.paimon.types.VarBinaryType(varBinaryType.isNullable(), varBinaryType.getLength());
    }

    public DataType visit(org.apache.flink.table.types.logical.DecimalType decimalType) {
        return new DecimalType(decimalType.isNullable(), decimalType.getPrecision(), decimalType.getScale());
    }

    public DataType visit(TinyIntType tinyIntType) {
        return new org.apache.paimon.types.TinyIntType(tinyIntType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.SmallIntType smallIntType) {
        return new SmallIntType(smallIntType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.IntType intType) {
        return new IntType(intType.isNullable());
    }

    public DataType visit(BigIntType bigIntType) {
        return new org.apache.paimon.types.BigIntType(bigIntType.isNullable());
    }

    public DataType visit(FloatType floatType) {
        return new org.apache.paimon.types.FloatType(floatType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.DoubleType doubleType) {
        return new DoubleType(doubleType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.DateType dateType) {
        return new DateType(dateType.isNullable());
    }

    public DataType visit(org.apache.flink.table.types.logical.TimeType timeType) {
        return new TimeType(timeType.isNullable(), timeType.getPrecision());
    }

    public DataType visit(TimestampType timestampType) {
        return new org.apache.paimon.types.TimestampType(timestampType.isNullable(), timestampType.getPrecision());
    }

    public DataType visit(org.apache.flink.table.types.logical.LocalZonedTimestampType localZonedTimestampType) {
        return new LocalZonedTimestampType(localZonedTimestampType.isNullable(), localZonedTimestampType.getPrecision());
    }

    public DataType visit(ArrayType arrayType) {
        return new org.apache.paimon.types.ArrayType(arrayType.isNullable(), (DataType)arrayType.getElementType().accept((LogicalTypeVisitor)this));
    }

    public DataType visit(org.apache.flink.table.types.logical.MultisetType multisetType) {
        return new MultisetType(multisetType.isNullable(), (DataType)multisetType.getElementType().accept((LogicalTypeVisitor)this));
    }

    public DataType visit(MapType mapType) {
        return new org.apache.paimon.types.MapType(mapType.isNullable(), (DataType)mapType.getKeyType().accept((LogicalTypeVisitor)this), (DataType)mapType.getValueType().accept((LogicalTypeVisitor)this));
    }

    public DataType visit(org.apache.flink.table.types.logical.RowType rowType) {
        ArrayList<DataField> dataFields = new ArrayList<DataField>();
        for (RowType.RowField field : rowType.getFields()) {
            int id = this.currentHighestFieldId.incrementAndGet();
            DataType fieldType = (DataType)field.getType().accept((LogicalTypeVisitor)this);
            dataFields.add(new DataField(id, field.getName(), fieldType, field.getDescription().orElse(null)));
        }
        return new RowType(rowType.isNullable(), dataFields);
    }

    public DataType visit(VariantType variantType) {
        return new org.apache.paimon.types.VariantType();
    }

    protected DataType defaultMethod(LogicalType logicalType) {
        throw new UnsupportedOperationException("Unsupported type: " + logicalType);
    }
}

