/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.math.BigDecimal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.flink.FlinkRowWrapper;
import org.apache.paimon.types.RowKind;

public class FlinkRowData
implements RowData {
    private InternalRow row;

    public FlinkRowData(InternalRow row) {
        this.row = row;
    }

    public FlinkRowData replace(InternalRow row) {
        this.row = row;
        return this;
    }

    public int getArity() {
        return this.row.getFieldCount();
    }

    public org.apache.flink.types.RowKind getRowKind() {
        return FlinkRowData.toFlinkRowKind(this.row.getRowKind());
    }

    public void setRowKind(org.apache.flink.types.RowKind kind) {
        this.row.setRowKind(FlinkRowWrapper.fromFlinkRowKind(kind));
    }

    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.row.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.row.getByte(pos);
    }

    public short getShort(int pos) {
        return this.row.getShort(pos);
    }

    public int getInt(int pos) {
        return this.row.getInt(pos);
    }

    public long getLong(int pos) {
        return this.row.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.row.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.row.getDouble(pos);
    }

    public StringData getString(int pos) {
        return FlinkRowData.toFlinkString(this.row.getString(pos));
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return FlinkRowData.toFlinkDecimal(this.row.getDecimal(pos, precision, scale));
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return FlinkRowData.toFlinkTimestamp(this.row.getTimestamp(pos, precision));
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBinary(int pos) {
        return this.row.getBinary(pos);
    }

    public ArrayData getArray(int pos) {
        return new FlinkArrayData(this.row.getArray(pos));
    }

    public MapData getMap(int pos) {
        return new FlinkMapData(this.row.getMap(pos));
    }

    public RowData getRow(int pos, int numFields) {
        return new FlinkRowData(this.row.getRow(pos, numFields));
    }

    public org.apache.flink.types.variant.Variant getVariant(int pos) {
        Variant variant = this.row.getVariant(pos);
        return new BinaryVariant(variant.value(), variant.metadata());
    }

    public static StringData toFlinkString(BinaryString str) {
        return StringData.fromBytes((byte[])str.toBytes());
    }

    public static TimestampData toFlinkTimestamp(Timestamp timestamp) {
        return TimestampData.fromEpochMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public static DecimalData toFlinkDecimal(Decimal decimal) {
        if (decimal.isCompact()) {
            return DecimalData.fromUnscaledLong((long)decimal.toUnscaledLong(), (int)decimal.precision(), (int)decimal.scale());
        }
        return DecimalData.fromBigDecimal((BigDecimal)decimal.toBigDecimal(), (int)decimal.precision(), (int)decimal.scale());
    }

    public static org.apache.flink.types.RowKind toFlinkRowKind(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: {
                return org.apache.flink.types.RowKind.INSERT;
            }
            case UPDATE_BEFORE: {
                return org.apache.flink.types.RowKind.UPDATE_BEFORE;
            }
            case UPDATE_AFTER: {
                return org.apache.flink.types.RowKind.UPDATE_AFTER;
            }
            case DELETE: {
                return org.apache.flink.types.RowKind.DELETE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class FlinkMapData
    implements MapData {
        private final InternalMap map;

        private FlinkMapData(InternalMap map) {
            this.map = map;
        }

        public int size() {
            return this.map.size();
        }

        public ArrayData keyArray() {
            return new FlinkArrayData(this.map.keyArray());
        }

        public ArrayData valueArray() {
            return new FlinkArrayData(this.map.valueArray());
        }
    }

    private static class FlinkArrayData
    implements ArrayData {
        private final InternalArray array;

        private FlinkArrayData(InternalArray array) {
            this.array = array;
        }

        public int size() {
            return this.array.size();
        }

        public boolean isNullAt(int pos) {
            return this.array.isNullAt(pos);
        }

        public boolean getBoolean(int pos) {
            return this.array.getBoolean(pos);
        }

        public byte getByte(int pos) {
            return this.array.getByte(pos);
        }

        public short getShort(int pos) {
            return this.array.getShort(pos);
        }

        public int getInt(int pos) {
            return this.array.getInt(pos);
        }

        public long getLong(int pos) {
            return this.array.getLong(pos);
        }

        public float getFloat(int pos) {
            return this.array.getFloat(pos);
        }

        public double getDouble(int pos) {
            return this.array.getDouble(pos);
        }

        public StringData getString(int pos) {
            return FlinkRowData.toFlinkString(this.array.getString(pos));
        }

        public DecimalData getDecimal(int pos, int precision, int scale) {
            return FlinkRowData.toFlinkDecimal(this.array.getDecimal(pos, precision, scale));
        }

        public TimestampData getTimestamp(int pos, int precision) {
            return FlinkRowData.toFlinkTimestamp(this.array.getTimestamp(pos, precision));
        }

        public <T> RawValueData<T> getRawValue(int pos) {
            throw new UnsupportedOperationException();
        }

        public org.apache.flink.types.variant.Variant getVariant(int pos) {
            Variant variant = this.array.getVariant(pos);
            return new BinaryVariant(variant.value(), variant.metadata());
        }

        public byte[] getBinary(int pos) {
            return this.array.getBinary(pos);
        }

        public ArrayData getArray(int pos) {
            return new FlinkArrayData(this.array.getArray(pos));
        }

        public MapData getMap(int pos) {
            return new FlinkMapData(this.array.getMap(pos));
        }

        public RowData getRow(int pos, int numFields) {
            return new FlinkRowData(this.array.getRow(pos, numFields));
        }

        public boolean[] toBooleanArray() {
            return this.array.toBooleanArray();
        }

        public byte[] toByteArray() {
            return this.array.toByteArray();
        }

        public short[] toShortArray() {
            return this.array.toShortArray();
        }

        public int[] toIntArray() {
            return this.array.toIntArray();
        }

        public long[] toLongArray() {
            return this.array.toLongArray();
        }

        public float[] toFloatArray() {
            return this.array.toFloatArray();
        }

        public double[] toDoubleArray() {
            return this.array.toDoubleArray();
        }
    }
}

