/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap.dictionary.chunked;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.AbstractChunk;
import org.apache.paimon.fileindex.rangebitmap.dictionary.chunked.KeyFactory;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.IOUtils;

public class VariableLengthChunk
extends AbstractChunk {
    public static final byte CURRENT_VERSION = 1;
    private final byte version;
    private final Object key;
    private final int code;
    private final int offset;
    private int size;
    private int currentOffset;
    private int keysBaseOffset;
    private int offsetsLength;
    private int keysLength;
    private SeekableInputStream in;
    private ByteBuffer offsets;
    private ByteBuffer keys;
    private KeyFactory.KeySerializer serializer;
    private KeyFactory.KeyDeserializer deserializer;

    public VariableLengthChunk(Object key, int code, int offset, int limitedSerializedSizeInBytes, KeyFactory.KeySerializer serializer, Comparator<Object> comparator) {
        super(comparator);
        this.version = 1;
        this.key = key;
        this.code = code;
        this.offset = offset;
        this.size = 0;
        this.currentOffset = 0;
        this.serializer = serializer;
        this.offsets = ByteBuffer.allocate(limitedSerializedSizeInBytes);
        this.keys = ByteBuffer.allocate(limitedSerializedSizeInBytes);
    }

    public VariableLengthChunk(ByteBuffer headers, int keysBaseOffset, SeekableInputStream in, KeyFactory.KeyDeserializer deserializer, Comparator<Object> comparator) {
        super(comparator);
        this.version = headers.get();
        if (this.version > 1) {
            throw new IllegalArgumentException("version out of range");
        }
        this.key = deserializer.deserialize(headers);
        this.code = headers.getInt();
        this.offset = headers.getInt();
        this.size = headers.getInt();
        this.offsetsLength = headers.getInt();
        this.keysLength = headers.getInt();
        this.keysBaseOffset = keysBaseOffset;
        this.in = in;
        this.deserializer = deserializer;
    }

    @Override
    public boolean tryAdd(Object key) {
        int length = this.serializer.serializedSizeInBytes(key);
        if (length > this.keys.remaining() || 4 > this.offsets.remaining()) {
            return false;
        }
        this.offsets.putInt(this.currentOffset);
        this.serializer.serialize(this.keys, key);
        this.currentOffset += length;
        ++this.size;
        return true;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    protected int size() {
        return this.size;
    }

    @Override
    protected Object get(int index) {
        if (this.offsets == null || this.keys == null) {
            try {
                this.in.seek(this.keysBaseOffset + this.offset);
                byte[] bytes = new byte[this.offsetsLength + this.keysLength];
                IOUtils.readFully((InputStream)this.in, bytes);
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                this.offsets = buffer.slice().limit(this.offsetsLength);
                buffer.position(this.offsetsLength);
                this.keys = buffer.slice().limit(this.keysLength);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.offsets.position(index * 4);
        this.keys.position(this.offsets.getInt());
        return this.deserializer.deserialize(this.keys);
    }

    @Override
    public byte[] serializeChunk() {
        this.offsets.flip();
        this.keys.flip();
        int serializedSizeInBytes = 0;
        ++serializedSizeInBytes;
        serializedSizeInBytes += this.serializer.serializedSizeInBytes(this.key);
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        serializedSizeInBytes += 4;
        ByteBuffer buffer = ByteBuffer.allocate(serializedSizeInBytes += 4);
        buffer.put(this.version);
        this.serializer.serialize(buffer, this.key);
        buffer.putInt(this.code);
        buffer.putInt(this.offset);
        buffer.putInt(this.size);
        buffer.putInt(this.offsets.limit());
        buffer.putInt(this.keys.limit());
        return buffer.array();
    }

    @Override
    public byte[] serializeKeys() {
        ByteBuffer buffer = ByteBuffer.allocate(this.offsets.limit() + this.keys.limit());
        buffer.put(this.offsets);
        buffer.put(this.keys);
        return buffer.array();
    }
}

