/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.rangebitmap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.RoaringBitmap32;

public class BitSliceIndexBitmap {
    public static final byte VERSION_1 = 1;
    public static final byte CURRENT_VERSION = 1;
    private final int ebmLength;
    private final ByteBuffer indexes;
    private final RoaringBitmap32[] slices;
    private final SeekableInputStream in;
    private final int bodyOffset;
    private RoaringBitmap32 ebm;
    private boolean initialized = false;

    public BitSliceIndexBitmap(SeekableInputStream in, int offset) throws IOException {
        in.seek(offset);
        byte[] headerLengthInBytes = new byte[4];
        IOUtils.readFully((InputStream)in, headerLengthInBytes);
        int headerLength = ByteBuffer.wrap(headerLengthInBytes).getInt();
        byte[] headerInBytes = new byte[headerLength];
        IOUtils.readFully((InputStream)in, headerInBytes);
        ByteBuffer headers = ByteBuffer.wrap(headerInBytes);
        byte version = headers.get();
        if (version > 1) {
            throw new RuntimeException(String.format("deserialize bsi index fail, current version is lower than %d", version));
        }
        this.slices = new RoaringBitmap32[headers.get()];
        this.ebmLength = headers.getInt();
        int indexesLength = headers.getInt();
        this.indexes = headers.slice().limit(indexesLength);
        this.in = in;
        this.bodyOffset = offset + 4 + headerLength;
    }

    @Nullable
    public Integer get(int key) {
        if (!this.isNotNull().contains(key)) {
            return null;
        }
        int value = 0;
        for (int i = 0; i < this.slices.length; ++i) {
            if (!this.getSlice(i).contains(key)) continue;
            value |= 1 << i;
        }
        return value;
    }

    public RoaringBitmap32 eq(int code) {
        RoaringBitmap32 state = this.isNotNull();
        if (state.isEmpty()) {
            return new RoaringBitmap32();
        }
        this.loadSlices(0, this.slices.length);
        for (int i = 0; i < this.slices.length; ++i) {
            int bit = code >> i & 1;
            if (bit == 1) {
                state.and(this.getSlice(i));
                continue;
            }
            state.andNot(this.getSlice(i));
        }
        return state;
    }

    public RoaringBitmap32 gt(int code) {
        if (code < 0) {
            return this.isNotNull();
        }
        RoaringBitmap32 foundSet = this.isNotNull();
        if (foundSet.isEmpty()) {
            return new RoaringBitmap32();
        }
        RoaringBitmap32 state = null;
        int start = Long.numberOfTrailingZeros(~code);
        this.loadSlices(start, this.slices.length);
        for (int i = start; i < this.slices.length; ++i) {
            if (state == null) {
                state = this.getSlice(i).clone();
                continue;
            }
            long bit = code >> i & 1;
            if (bit == 1L) {
                state.and(this.getSlice(i));
                continue;
            }
            state.or(this.getSlice(i));
        }
        if (state == null) {
            return new RoaringBitmap32();
        }
        state.and(foundSet);
        return state;
    }

    public RoaringBitmap32 gte(int code) {
        return this.gt(code - 1);
    }

    public RoaringBitmap32 topK(int k, @Nullable RoaringBitmap32 foundSet, boolean strict) {
        if (k == 0 || foundSet != null && foundSet.isEmpty()) {
            return new RoaringBitmap32();
        }
        if (k < 0) {
            throw new IllegalArgumentException("the k param can not be negative in topK, k=" + k);
        }
        RoaringBitmap32 g = new RoaringBitmap32();
        RoaringBitmap32 e = this.isNotNull(foundSet);
        if (e.getCardinality() <= (long)k) {
            return e;
        }
        this.loadSlices(0, this.slices.length);
        for (int i = this.slices.length - 1; i >= 0; --i) {
            RoaringBitmap32 x = RoaringBitmap32.or(g, RoaringBitmap32.and(e, this.getSlice(i)));
            long n = x.getCardinality();
            if (n > (long)k) {
                e = RoaringBitmap32.and(e, this.getSlice(i));
                continue;
            }
            if (n < (long)k) {
                g = x;
                e = RoaringBitmap32.andNot(e, this.getSlice(i));
                continue;
            }
            e = RoaringBitmap32.and(e, this.getSlice(i));
            break;
        }
        RoaringBitmap32 f = RoaringBitmap32.or(g, e);
        if (!strict) {
            return f;
        }
        long n = f.getCardinality() - (long)k;
        if (n > 0L) {
            Iterator<Integer> iterator = e.iterator();
            while (iterator.hasNext() && n > 0L) {
                f.remove(iterator.next());
                --n;
            }
        }
        return f;
    }

    public RoaringBitmap32 bottomK(int k, @Nullable RoaringBitmap32 foundSet, boolean strict) {
        if (k == 0 || foundSet != null && foundSet.isEmpty()) {
            return new RoaringBitmap32();
        }
        if (k < 0) {
            throw new IllegalArgumentException("the k param can not be negative in bottomK, k=" + k);
        }
        RoaringBitmap32 g = new RoaringBitmap32();
        RoaringBitmap32 e = this.isNotNull(foundSet);
        if (e.getCardinality() <= (long)k) {
            return e;
        }
        this.loadSlices(0, this.slices.length);
        for (int i = this.slices.length - 1; i >= 0; --i) {
            RoaringBitmap32 x = RoaringBitmap32.or(g, RoaringBitmap32.andNot(e, this.getSlice(i)));
            long n = x.getCardinality();
            if (n > (long)k) {
                e = RoaringBitmap32.andNot(e, this.getSlice(i));
                continue;
            }
            if (n < (long)k) {
                g = x;
                e = RoaringBitmap32.and(e, this.getSlice(i));
                continue;
            }
            e = RoaringBitmap32.andNot(e, this.getSlice(i));
            break;
        }
        RoaringBitmap32 f = RoaringBitmap32.or(g, e);
        if (!strict) {
            return f;
        }
        long n = f.getCardinality() - (long)k;
        if (n > 0L) {
            Iterator<Integer> iterator = e.iterator();
            while (iterator.hasNext() && n > 0L) {
                f.remove(iterator.next());
                --n;
            }
        }
        return f;
    }

    public RoaringBitmap32 isNotNull() {
        return this.isNotNull(null);
    }

    private RoaringBitmap32 isNotNull(@Nullable RoaringBitmap32 foundSet) {
        if (this.ebm == null) {
            try {
                this.in.seek(this.bodyOffset);
                byte[] bytes = new byte[this.ebmLength];
                IOUtils.readFully((InputStream)this.in, bytes);
                RoaringBitmap32 bitmap = new RoaringBitmap32();
                bitmap.deserialize(ByteBuffer.wrap(bytes));
                this.ebm = bitmap;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return foundSet == null ? this.ebm.clone() : RoaringBitmap32.and(this.ebm, foundSet);
    }

    private void loadSlices(int begin, int end) {
        if (this.initialized) {
            return;
        }
        this.indexes.position(8 * begin);
        int offset = this.indexes.getInt();
        int length = this.indexes.getInt();
        int[] lengths = new int[end];
        lengths[begin] = length;
        for (int i = begin + 1; i < end; ++i) {
            this.indexes.getInt();
            lengths[i] = this.indexes.getInt();
            length += lengths[i];
        }
        try {
            this.in.seek(this.bodyOffset + this.ebmLength + offset);
            byte[] bytes = new byte[length];
            IOUtils.readFully((InputStream)this.in, bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int position = 0;
            for (int i = begin; i < end; ++i) {
                buffer.position(position);
                RoaringBitmap32 slice = new RoaringBitmap32();
                slice.deserialize(buffer.slice().limit(lengths[i]));
                this.slices[i] = slice;
                position += lengths[i];
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    private RoaringBitmap32 getSlice(int index) {
        if (this.slices[index] == null) {
            this.indexes.position(8 * index);
            int offset = this.indexes.getInt();
            int length = this.indexes.getInt();
            try {
                this.in.seek(this.bodyOffset + this.ebmLength + offset);
                byte[] bytes = new byte[length];
                IOUtils.readFully((InputStream)this.in, bytes);
                RoaringBitmap32 slice = new RoaringBitmap32();
                slice.deserialize(ByteBuffer.wrap(bytes));
                this.slices[index] = slice;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.slices[index];
    }

    public static final class Appender {
        private final int min;
        private final int max;
        private final RoaringBitmap32 ebm;
        private final RoaringBitmap32[] slices;

        public Appender(int min, int max) {
            this.min = min;
            this.max = max;
            this.ebm = new RoaringBitmap32();
            this.slices = new RoaringBitmap32[Math.max(64 - Long.numberOfLeadingZeros(max), 1)];
            for (int i = 0; i < this.slices.length; ++i) {
                this.slices[i] = new RoaringBitmap32();
            }
        }

        public void append(int key, int value) {
            if (value < 0) {
                throw new UnsupportedOperationException("value can not be negative");
            }
            if (value < this.min || value > this.max) {
                throw new IllegalArgumentException("value not in range [" + this.min + "," + this.max + "]");
            }
            for (long bits = (long)value; bits != 0L; bits &= bits - 1L) {
                this.slices[Long.numberOfTrailingZeros(bits)].add(key);
            }
            this.ebm.add(key);
        }

        public ByteBuffer serialize() {
            int indexesLength = 8 * this.slices.length;
            byte[] ebmSerializeInBytes = this.ebm.serialize();
            int ebmLength = ebmSerializeInBytes.length;
            int headerSize = 0;
            ++headerSize;
            ++headerSize;
            headerSize += 4;
            headerSize += 4;
            headerSize += indexesLength;
            int bodySize = 0;
            bodySize += ebmLength;
            int offset = 0;
            ByteBuffer indexes = ByteBuffer.allocate(indexesLength);
            ArrayList<byte[]> slicesSerializeInBytes = new ArrayList<byte[]>();
            for (RoaringBitmap32 slice : this.slices) {
                byte[] sliceInBytes = slice.serialize();
                slicesSerializeInBytes.add(sliceInBytes);
                int length = sliceInBytes.length;
                indexes.putInt(offset);
                indexes.putInt(length);
                offset += length;
                bodySize += length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(4 + headerSize + bodySize);
            buffer.putInt(headerSize);
            buffer.put((byte)1);
            buffer.put((byte)this.slices.length);
            buffer.putInt(ebmLength);
            buffer.putInt(indexesLength);
            buffer.put(indexes.array());
            buffer.put(ebmSerializeInBytes);
            for (byte[] slice : slicesSerializeInBytes) {
                buffer.put(slice);
            }
            return buffer;
        }
    }
}

