/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.StringUtils;

@Public
public interface FileIOChannel {
    public ID getChannelID();

    public long getSize() throws IOException;

    public boolean isClosed();

    public void close() throws IOException;

    public void deleteChannel();

    public FileChannel getNioFileChannel();

    public void closeAndDelete() throws IOException;

    public static final class Enumerator {
        private static final AtomicInteger GLOBAL_NUMBER = new AtomicInteger();
        private final File[] paths;
        private final String namePrefix;
        private int localCounter;

        public Enumerator(File[] basePaths, Random random) {
            this.paths = basePaths;
            this.namePrefix = ID.randomString(random);
            this.localCounter = 0;
        }

        public ID next() {
            int bucketNum = GLOBAL_NUMBER.getAndIncrement() % this.paths.length;
            String filename = String.format("%s.%06d.channel", this.namePrefix, this.localCounter++);
            return new ID(new File(this.paths[bucketNum], filename), bucketNum);
        }
    }

    public static class ID {
        private static final int RANDOM_BYTES_LENGTH = 16;
        private final File path;
        private final int bucketNum;

        private ID(File path, int bucketNum) {
            this.path = path;
            this.bucketNum = bucketNum;
        }

        public ID(File basePath, int bucketNum, Random random) {
            this.path = new File(basePath, ID.randomString(random) + ".channel");
            this.bucketNum = bucketNum;
        }

        public ID(File basePath, int bucketNum, String prefix, Random random) {
            this.path = new File(basePath, prefix + "-" + ID.randomString(random) + ".channel");
            this.bucketNum = bucketNum;
        }

        public String getPath() {
            return this.path.getAbsolutePath();
        }

        public File getPathFile() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ID) {
                ID other = (ID)obj;
                return this.path.equals(other.path) && this.bucketNum == other.bucketNum;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path.getAbsolutePath();
        }

        private static String randomString(Random random) {
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return StringUtils.byteToHexString(bytes);
        }
    }
}

