/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors.append;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;

public class BucketedAppendDeleteFileMaintainer
implements BaseAppendDeleteFileMaintainer {
    private final BinaryRow partition;
    private final int bucket;
    private final BucketedDvMaintainer maintainer;

    BucketedAppendDeleteFileMaintainer(BinaryRow partition, int bucket, BucketedDvMaintainer maintainer) {
        this.partition = partition;
        this.bucket = bucket;
        this.maintainer = maintainer;
    }

    @Override
    public BinaryRow getPartition() {
        return this.partition;
    }

    @Override
    public int getBucket() {
        return this.bucket;
    }

    @Override
    public void notifyNewDeletionVector(String dataFile, DeletionVector deletionVector) {
        this.maintainer.mergeNewDeletion(dataFile, deletionVector);
    }

    @Override
    public List<IndexManifestEntry> persist() {
        ArrayList<IndexManifestEntry> result = new ArrayList<IndexManifestEntry>();
        this.maintainer.writeDeletionVectorsIndex().map(fileMeta -> new IndexManifestEntry(FileKind.ADD, this.partition, this.bucket, (IndexFileMeta)fileMeta)).ifPresent(result::add);
        return result;
    }
}

