/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.Bitmap64DeletionVector;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;

public class BucketedDvMaintainer {
    private final DeletionVectorsIndexFile dvIndexFile;
    private final Map<String, DeletionVector> deletionVectors;
    protected final boolean bitmap64;
    private boolean modified;

    private BucketedDvMaintainer(DeletionVectorsIndexFile dvIndexFile, Map<String, DeletionVector> deletionVectors) {
        this.dvIndexFile = dvIndexFile;
        this.deletionVectors = deletionVectors;
        this.bitmap64 = dvIndexFile.bitmap64();
        this.modified = false;
    }

    private DeletionVector createNewDeletionVector() {
        return this.bitmap64 ? new Bitmap64DeletionVector() : new BitmapDeletionVector();
    }

    public void notifyNewDeletion(String fileName, long position) {
        DeletionVector deletionVector = this.deletionVectors.computeIfAbsent(fileName, k -> this.createNewDeletionVector());
        if (deletionVector.checkedDelete(position)) {
            this.modified = true;
        }
    }

    public void notifyNewDeletion(String fileName, DeletionVector deletionVector) {
        this.deletionVectors.put(fileName, deletionVector);
        this.modified = true;
    }

    public void mergeNewDeletion(String fileName, DeletionVector deletionVector) {
        DeletionVector old = this.deletionVectors.get(fileName);
        if (old != null) {
            deletionVector.merge(old);
        }
        this.deletionVectors.put(fileName, deletionVector);
        this.modified = true;
    }

    public void removeDeletionVectorOf(String fileName) {
        if (this.deletionVectors.containsKey(fileName)) {
            this.deletionVectors.remove(fileName);
            this.modified = true;
        }
    }

    public Optional<IndexFileMeta> writeDeletionVectorsIndex() {
        if (this.modified) {
            this.modified = false;
            return Optional.of(this.dvIndexFile.writeSingleFile(this.deletionVectors));
        }
        return Optional.empty();
    }

    public Optional<DeletionVector> deletionVectorOf(String fileName) {
        return Optional.ofNullable(this.deletionVectors.get(fileName));
    }

    public DeletionVectorsIndexFile dvIndexFile() {
        return this.dvIndexFile;
    }

    @VisibleForTesting
    public Map<String, DeletionVector> deletionVectors() {
        return this.deletionVectors;
    }

    public boolean bitmap64() {
        return this.bitmap64;
    }

    public static Factory factory(IndexFileHandler handler) {
        return new Factory(handler);
    }

    public static class Factory {
        private final IndexFileHandler handler;

        private Factory(IndexFileHandler handler) {
            this.handler = handler;
        }

        public IndexFileHandler indexFileHandler() {
            return this.handler;
        }

        public BucketedDvMaintainer create(BinaryRow partition, int bucket, @Nullable List<IndexFileMeta> restoredFiles) {
            if (restoredFiles == null) {
                restoredFiles = Collections.emptyList();
            }
            HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>(this.handler.readAllDeletionVectors(partition, bucket, restoredFiles));
            return this.create(partition, bucket, deletionVectors);
        }

        public BucketedDvMaintainer create(BinaryRow partition, int bucket, Map<String, DeletionVector> deletionVectors) {
            return new BucketedDvMaintainer(this.handler.dvIndex(partition, bucket), deletionVectors);
        }
    }
}

