/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.CRC32;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.utils.RoaringBitmap32;

public class BitmapDeletionVector
implements DeletionVector {
    public static final int MAGIC_NUMBER = 1581511376;
    public static final int MAGIC_NUMBER_SIZE_BYTES = 4;
    private final RoaringBitmap32 roaringBitmap;

    public BitmapDeletionVector() {
        this.roaringBitmap = new RoaringBitmap32();
    }

    private BitmapDeletionVector(RoaringBitmap32 roaringBitmap) {
        this.roaringBitmap = roaringBitmap;
    }

    @Override
    public void delete(long position) {
        this.checkPosition(position);
        this.roaringBitmap.add((int)position);
    }

    @Override
    public void merge(DeletionVector deletionVector) {
        if (!(deletionVector instanceof BitmapDeletionVector)) {
            throw new RuntimeException("Only instance with the same class type can be merged.");
        }
        this.roaringBitmap.or(((BitmapDeletionVector)deletionVector).roaringBitmap);
    }

    @Override
    public boolean checkedDelete(long position) {
        this.checkPosition(position);
        return this.roaringBitmap.checkedAdd((int)position);
    }

    @Override
    public boolean isDeleted(long position) {
        this.checkPosition(position);
        return this.roaringBitmap.contains((int)position);
    }

    @Override
    public boolean isEmpty() {
        return this.roaringBitmap.isEmpty();
    }

    @Override
    public long getCardinality() {
        return this.roaringBitmap.getCardinality();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int serializeTo(DataOutputStream out) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int n;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeInt(1581511376);
                this.roaringBitmap.serialize(dos);
                byte[] data = bos.toByteArray();
                int size = data.length;
                out.writeInt(size);
                out.write(data);
                out.writeInt(BitmapDeletionVector.calculateChecksum(data));
                n = size;
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to serialize deletion vector", e);
        }
    }

    public RoaringBitmap32 get() {
        return this.roaringBitmap;
    }

    public static DeletionVector deserializeFromByteBuffer(ByteBuffer buffer) throws IOException {
        RoaringBitmap32 bitmap = new RoaringBitmap32();
        bitmap.deserialize(buffer);
        return new BitmapDeletionVector(bitmap);
    }

    private void checkPosition(long position) {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The file has too many rows, RoaringBitmap32 only supports files with row count not exceeding 2147483647.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapDeletionVector that = (BitmapDeletionVector)o;
        return Objects.equals(this.roaringBitmap, that.roaringBitmap);
    }

    public int hashCode() {
        return Objects.hashCode(this.roaringBitmap);
    }

    public static int calculateChecksum(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return (int)crc.getValue();
    }
}

