/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.variant;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.columnar.RowColumnVector;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.variant.GenericVariant;
import org.apache.paimon.data.variant.ShreddingUtils;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.data.variant.VariantSchema;
import org.apache.paimon.data.variant.VariantShreddingWriter;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarBinaryType;

public class PaimonShreddingUtils {
    public static final String METADATA_FIELD_NAME = "metadata";
    public static final String VARIANT_VALUE_FIELD_NAME = "value";
    public static final String TYPED_VALUE_FIELD_NAME = "typed_value";

    public static RowType variantShreddingSchema(RowType rowType) {
        return PaimonShreddingUtils.variantShreddingSchema(rowType, true);
    }

    private static RowType variantShreddingSchema(DataType dataType, boolean topLevel) {
        RowType.Builder builder = RowType.builder();
        if (topLevel) {
            builder.field(METADATA_FIELD_NAME, DataTypes.BYTES());
        }
        switch (dataType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)dataType;
                ArrayType shreddedArrayType = new ArrayType(arrayType.isNullable(), PaimonShreddingUtils.variantShreddingSchema(arrayType.getElementType(), false));
                builder.field(VARIANT_VALUE_FIELD_NAME, DataTypes.BYTES());
                builder.field(TYPED_VALUE_FIELD_NAME, shreddedArrayType);
                break;
            }
            case ROW: {
                RowType rowType = (RowType)dataType;
                RowType shreddedRowType = rowType.copy(rowType.getFields().stream().map(field -> field.newType(PaimonShreddingUtils.variantShreddingSchema(field.type(), false).notNull())).collect(Collectors.toList()));
                builder.field(VARIANT_VALUE_FIELD_NAME, DataTypes.BYTES());
                builder.field(TYPED_VALUE_FIELD_NAME, shreddedRowType);
                break;
            }
            case VARIANT: {
                builder.field(VARIANT_VALUE_FIELD_NAME, DataTypes.BYTES());
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: 
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                builder.field(VARIANT_VALUE_FIELD_NAME, DataTypes.BYTES());
                builder.field(TYPED_VALUE_FIELD_NAME, dataType);
                break;
            }
            default: {
                throw PaimonShreddingUtils.invalidVariantShreddingSchema(dataType);
            }
        }
        return builder.build();
    }

    public static VariantSchema buildVariantSchema(RowType rowType) {
        return PaimonShreddingUtils.buildVariantSchema(rowType, true);
    }

    private static VariantSchema buildVariantSchema(RowType rowType, boolean topLevel) {
        int typedIdx = -1;
        int variantIdx = -1;
        int topLevelMetadataIdx = -1;
        VariantSchema.ScalarType scalarSchema = null;
        VariantSchema.ObjectField[] objectSchema = null;
        VariantSchema arraySchema = null;
        if (rowType.getFields().isEmpty()) {
            throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
        }
        List<DataField> fields = rowType.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DataField field = fields.get(i);
            DataType dataType = field.type();
            block5 : switch (field.name()) {
                case "typed_value": {
                    if (typedIdx != -1) {
                        throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                    }
                    typedIdx = i;
                    switch (field.type().getTypeRoot()) {
                        case ROW: {
                            RowType r = (RowType)dataType;
                            List<DataField> rFields = r.getFields();
                            if (fields.isEmpty() || fields.stream().distinct().count() != (long)fields.size()) {
                                throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                            }
                            objectSchema = new VariantSchema.ObjectField[rFields.size()];
                            for (int index = 0; index < rFields.size(); ++index) {
                                if (!(field.type() instanceof RowType)) {
                                    throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                                }
                                DataField f = rFields.get(index);
                                objectSchema[index] = new VariantSchema.ObjectField(f.name(), PaimonShreddingUtils.buildVariantSchema((RowType)f.type(), false));
                            }
                            break block5;
                        }
                        case ARRAY: {
                            ArrayType arrayType = (ArrayType)dataType;
                            if (arrayType.getElementType() instanceof RowType) {
                                arraySchema = PaimonShreddingUtils.buildVariantSchema((RowType)arrayType.getElementType(), false);
                                break block5;
                            }
                            throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                        }
                        case BOOLEAN: {
                            scalarSchema = new VariantSchema.BooleanType();
                            break block5;
                        }
                        case TINYINT: {
                            scalarSchema = new VariantSchema.IntegralType(VariantSchema.IntegralSize.BYTE);
                            break block5;
                        }
                        case SMALLINT: {
                            scalarSchema = new VariantSchema.IntegralType(VariantSchema.IntegralSize.SHORT);
                            break block5;
                        }
                        case INTEGER: {
                            scalarSchema = new VariantSchema.IntegralType(VariantSchema.IntegralSize.INT);
                            break block5;
                        }
                        case BIGINT: {
                            scalarSchema = new VariantSchema.IntegralType(VariantSchema.IntegralSize.LONG);
                            break block5;
                        }
                        case FLOAT: {
                            scalarSchema = new VariantSchema.FloatType();
                            break block5;
                        }
                        case DOUBLE: {
                            scalarSchema = new VariantSchema.DoubleType();
                            break block5;
                        }
                        case VARCHAR: {
                            scalarSchema = new VariantSchema.StringType();
                            break block5;
                        }
                        case BINARY: {
                            scalarSchema = new VariantSchema.BinaryType();
                            break block5;
                        }
                        case DATE: {
                            scalarSchema = new VariantSchema.DateType();
                            break block5;
                        }
                        case DECIMAL: {
                            DecimalType d = (DecimalType)dataType;
                            scalarSchema = new VariantSchema.DecimalType(d.getPrecision(), d.getScale());
                            break block5;
                        }
                        default: {
                            throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                        }
                    }
                }
                case "value": {
                    if (variantIdx != -1 || !(field.type() instanceof VarBinaryType)) {
                        throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                    }
                    variantIdx = i;
                    break;
                }
                case "metadata": {
                    if (topLevelMetadataIdx != -1 || !(field.type() instanceof VarBinaryType)) {
                        throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                    }
                    topLevelMetadataIdx = i;
                    break;
                }
                default: {
                    throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
                }
            }
            if (!topLevel || topLevelMetadataIdx != -1) continue;
            topLevelMetadataIdx = i;
        }
        if (topLevel != topLevelMetadataIdx >= 0) {
            throw PaimonShreddingUtils.invalidVariantShreddingSchema(rowType);
        }
        return new VariantSchema(typedIdx, variantIdx, topLevelMetadataIdx, fields.size(), scalarSchema, objectSchema, arraySchema);
    }

    private static RuntimeException invalidVariantShreddingSchema(DataType dataType) {
        return new RuntimeException("Invalid variant shredding schema: " + dataType);
    }

    public static InternalRow castShredded(GenericVariant variant, VariantSchema variantSchema) {
        return ((PaimonShreddedResult)VariantShreddingWriter.castShredded((GenericVariant)variant, (VariantSchema)variantSchema, (VariantShreddingWriter.ShreddedResultBuilder)new PaimonShreddedResultBuilder())).row;
    }

    public static Variant rebuild(InternalRow row, VariantSchema variantSchema) {
        return ShreddingUtils.rebuild(new PaimonShreddedRow(row), variantSchema);
    }

    public static void assembleVariantBatch(WritableColumnVector input, WritableColumnVector output, VariantSchema variantSchema) {
        int numRows = input.getElementsAppended();
        output.reset();
        output.reserve(numRows);
        WritableBytesVector valueChild = (WritableBytesVector)output.getChildren()[0];
        WritableBytesVector metadataChild = (WritableBytesVector)output.getChildren()[1];
        for (int i = 0; i < numRows; ++i) {
            if (input.isNullAt(i)) {
                output.setNullAt(i);
                continue;
            }
            Variant v = PaimonShreddingUtils.rebuild(((RowColumnVector)((Object)input)).getRow(i), variantSchema);
            byte[] value = v.value();
            byte[] metadata = v.metadata();
            valueChild.putByteArray(i, value, 0, value.length);
            metadataChild.putByteArray(i, metadata, 0, metadata.length);
        }
    }

    public static class PaimonShreddedResultBuilder
    implements VariantShreddingWriter.ShreddedResultBuilder {
        @Override
        public VariantShreddingWriter.ShreddedResult createEmpty(VariantSchema schema) {
            return new PaimonShreddedResult(schema);
        }

        @Override
        public boolean allowNumericScaleChanges() {
            return true;
        }
    }

    public static class PaimonShreddedResult
    implements VariantShreddingWriter.ShreddedResult {
        private final VariantSchema schema;
        private final GenericRow row;

        public PaimonShreddedResult(VariantSchema schema) {
            this.schema = schema;
            this.row = new GenericRow(schema.numFields);
        }

        @Override
        public void addArray(VariantShreddingWriter.ShreddedResult[] array) {
            GenericArray arrayResult = new GenericArray(Arrays.stream(array).map(result -> ((PaimonShreddedResult)result).row).toArray(InternalRow[]::new));
            this.row.setField(this.schema.typedIdx, arrayResult);
        }

        @Override
        public void addObject(VariantShreddingWriter.ShreddedResult[] values) {
            GenericRow innerRow = new GenericRow(this.schema.objectSchema.length);
            for (int i = 0; i < values.length; ++i) {
                innerRow.setField(i, ((PaimonShreddedResult)values[i]).row);
            }
            this.row.setField(this.schema.typedIdx, innerRow);
        }

        @Override
        public void addVariantValue(byte[] result) {
            this.row.setField(this.schema.variantIdx, result);
        }

        @Override
        public void addScalar(Object result) {
            Object paimonValue;
            if (this.schema.scalarSchema instanceof VariantSchema.StringType) {
                paimonValue = BinaryString.fromString((String)result);
            } else if (this.schema.scalarSchema instanceof VariantSchema.DecimalType) {
                VariantSchema.DecimalType dt = (VariantSchema.DecimalType)this.schema.scalarSchema;
                paimonValue = Decimal.fromBigDecimal((BigDecimal)result, dt.precision, dt.scale);
            } else {
                paimonValue = result;
            }
            this.row.setField(this.schema.typedIdx, paimonValue);
        }

        @Override
        public void addMetadata(byte[] result) {
            this.row.setField(this.schema.topLevelMetadataIdx, result);
        }
    }

    static class PaimonShreddedRow
    implements ShreddingUtils.ShreddedRow {
        private final DataGetters row;

        public PaimonShreddedRow(DataGetters row) {
            this.row = row;
        }

        @Override
        public boolean isNullAt(int ordinal) {
            return this.row.isNullAt(ordinal);
        }

        @Override
        public boolean getBoolean(int ordinal) {
            return this.row.getBoolean(ordinal);
        }

        @Override
        public byte getByte(int ordinal) {
            return this.row.getByte(ordinal);
        }

        @Override
        public short getShort(int ordinal) {
            return this.row.getShort(ordinal);
        }

        @Override
        public int getInt(int ordinal) {
            return this.row.getInt(ordinal);
        }

        @Override
        public long getLong(int ordinal) {
            return this.row.getLong(ordinal);
        }

        @Override
        public float getFloat(int ordinal) {
            return this.row.getFloat(ordinal);
        }

        @Override
        public double getDouble(int ordinal) {
            return this.row.getDouble(ordinal);
        }

        @Override
        public BigDecimal getDecimal(int ordinal, int precision, int scale) {
            return this.row.getDecimal(ordinal, precision, scale).toBigDecimal();
        }

        @Override
        public String getString(int ordinal) {
            return this.row.getString(ordinal).toString();
        }

        @Override
        public byte[] getBinary(int ordinal) {
            return this.row.getBinary(ordinal);
        }

        @Override
        public UUID getUuid(int ordinal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShreddingUtils.ShreddedRow getStruct(int ordinal, int numFields) {
            return new PaimonShreddedRow(this.row.getRow(ordinal, numFields));
        }

        @Override
        public ShreddingUtils.ShreddedRow getArray(int ordinal) {
            return new PaimonShreddedRow(this.row.getArray(ordinal));
        }

        @Override
        public int numElements() {
            return ((InternalArray)this.row).size();
        }
    }
}

