/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.LevelSortedRun;

public class CompactUnit {
    private final int outputLevel;
    private final List<DataFileMeta> files;
    private final boolean fileRewrite;

    public CompactUnit(int outputLevel, List<DataFileMeta> files, boolean fileRewrite) {
        this.outputLevel = outputLevel;
        this.files = files;
        this.fileRewrite = fileRewrite;
    }

    public int outputLevel() {
        return this.outputLevel;
    }

    public List<DataFileMeta> files() {
        return this.files;
    }

    public boolean fileRewrite() {
        return this.fileRewrite;
    }

    public static CompactUnit fromLevelRuns(int outputLevel, List<LevelSortedRun> runs) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>();
        for (LevelSortedRun run : runs) {
            files.addAll(run.run().files());
        }
        return CompactUnit.fromFiles(outputLevel, files, false);
    }

    public static CompactUnit fromFiles(int outputLevel, List<DataFileMeta> files, boolean fileRewrite) {
        return new CompactUnit(outputLevel, files, fileRewrite);
    }
}

