/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen.codesplit;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.paimon.codegen.codesplit.BlockStatementGrouper;
import org.apache.paimon.codegen.codesplit.BlockStatementSplitter;
import org.apache.paimon.codegen.codesplit.CodeRewriter;
import org.apache.paimon.codegen.codesplit.CodeSplitUtil;
import org.apache.paimon.codegen.codesplit.JavaLexer;
import org.apache.paimon.codegen.codesplit.JavaParser;
import org.apache.paimon.codegen.codesplit.JavaParserBaseVisitor;
import org.apache.paimon.shade.org.antlr.v4.runtime.CharStreams;
import org.apache.paimon.shade.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.paimon.shade.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.paimon.shade.org.antlr.v4.runtime.atn.PredictionMode;

public class BlockStatementRewriter
implements CodeRewriter {
    private final long maxMethodLength;
    private final BlockVisitor visitor;

    public BlockStatementRewriter(String code, long maxMethodLength) {
        this.maxMethodLength = maxMethodLength;
        this.visitor = new BlockVisitor(code);
    }

    @Override
    public String rewrite() {
        return this.visitor.rewriteAndGetCode();
    }

    private class BlockVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;

        private BlockVisitor(String code) {
            this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
            this.rewriter = new TokenStreamRewriter(this.tokenStream);
        }

        private String rewriteAndGetCode() {
            JavaParser javaParser = new JavaParser(this.tokenStream);
            ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            this.visit(javaParser.compilationUnit());
            return this.rewriter.getText();
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            final LinkedHashSet declarationContext = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarationContext.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit(ctx);
            String type = CodeSplitUtil.getContextString(ctx.typeTypeOrVoid());
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            Object methodQualifier = "";
            if (ctx.THROWS() != null) {
                methodQualifier = " throws " + CodeSplitUtil.getContextString(ctx.qualifiedNameList());
            }
            int counter2 = 0;
            for (JavaParser.BlockStatementContext blockStatementContext : ctx.methodBody().block().blockStatement()) {
                JavaParser.StatementContext statement = blockStatementContext.statement();
                if (statement == null || (long)statement.getText().length() <= BlockStatementRewriter.this.maxMethodLength || statement.IF() == null && statement.ELSE() == null && statement.WHILE() == null) continue;
                BlockStatementSplitter splitter = new BlockStatementSplitter(CodeSplitUtil.getContextString(statement), String.join((CharSequence)", ", declarationContext));
                String context = String.format(functionName + "_%d", counter2++);
                String blockRewrittenBody = splitter.rewriteBlock(context);
                Map<String, List<String>> newMethods = splitter.extractBlocks();
                StringBuilder functionGroupedBody = new StringBuilder();
                BlockStatementGrouper statementGrouper = new BlockStatementGrouper(blockRewrittenBody, BlockStatementRewriter.this.maxMethodLength, String.join((CharSequence)", ", declarationContext));
                BlockStatementGrouper.RewriteGroupedCode groupedCode = statementGrouper.rewrite(context);
                newMethods.putAll(groupedCode.getGroups());
                functionGroupedBody.append("\n").append(groupedCode.getRewriteCode());
                this.rewriter.replace(statement.start, statement.stop, (Object)functionGroupedBody);
                StringJoiner newMethodDefinitions = new StringJoiner(System.lineSeparator() + System.lineSeparator());
                for (Map.Entry<String, List<String>> entry : newMethods.entrySet()) {
                    StringBuilder sb = new StringBuilder(type).append(" ").append(entry.getKey()).append(parameters).append((String)methodQualifier).append(" {").append(System.lineSeparator());
                    StringJoiner bodyLines = new StringJoiner(System.lineSeparator());
                    for (String bodyLine : entry.getValue()) {
                        bodyLines.add(bodyLine);
                    }
                    sb.append(bodyLines).append(System.lineSeparator()).append("}");
                    newMethodDefinitions.add(sb.toString());
                }
                this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n\n" + newMethodDefinitions + "\n"));
            }
            return null;
        }
    }
}

