/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hadoop.SerializableConfiguration;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.HadoopUtils;
import org.apache.paimon.utils.Preconditions;

@Public
public class CatalogContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Options options;
    private final SerializableConfiguration hadoopConf;
    @Nullable
    private final FileIOLoader preferIOLoader;
    @Nullable
    private final FileIOLoader fallbackIOLoader;

    private CatalogContext(Options options, @Nullable Configuration hadoopConf, @Nullable FileIOLoader preferIOLoader, @Nullable FileIOLoader fallbackIOLoader) {
        this.options = Preconditions.checkNotNull(options);
        this.hadoopConf = new SerializableConfiguration(hadoopConf == null ? HadoopUtils.getHadoopConfiguration(options) : hadoopConf);
        this.preferIOLoader = preferIOLoader;
        this.fallbackIOLoader = fallbackIOLoader;
    }

    public static CatalogContext create(Path warehouse) {
        Options options = new Options();
        options.set(CatalogOptions.WAREHOUSE, warehouse.toUri().toString());
        return CatalogContext.create(options);
    }

    public static CatalogContext create(Options options) {
        return new CatalogContext(options, null, null, null);
    }

    public static CatalogContext create(Options options, Configuration hadoopConf) {
        return new CatalogContext(options, hadoopConf, null, null);
    }

    public static CatalogContext create(Options options, FileIOLoader fallbackIOLoader) {
        return new CatalogContext(options, null, null, fallbackIOLoader);
    }

    public static CatalogContext create(Options options, FileIOLoader preferIOLoader, FileIOLoader fallbackIOLoader) {
        return new CatalogContext(options, null, preferIOLoader, fallbackIOLoader);
    }

    public static CatalogContext create(Options options, Configuration hadoopConf, FileIOLoader preferIOLoader, FileIOLoader fallbackIOLoader) {
        return new CatalogContext(options, hadoopConf, preferIOLoader, fallbackIOLoader);
    }

    public Options options() {
        return this.options;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf.get();
    }

    @Nullable
    public FileIOLoader preferIO() {
        return this.preferIOLoader;
    }

    @Nullable
    public FileIOLoader fallbackIO() {
        return this.fallbackIOLoader;
    }
}

