/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.SortValue;
import org.apache.paimon.utils.ListUtils;
import org.apache.paimon.utils.Preconditions;

public class TopN
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<SortValue> orders;
    private final int limit;

    public TopN(List<SortValue> orders, int limit) {
        Preconditions.checkArgument((!ListUtils.isNullOrEmpty(orders) ? 1 : 0) != 0, (Object)"orders should not be null or empty");
        this.orders = orders;
        this.limit = limit;
    }

    public TopN(FieldRef ref, SortValue.SortDirection direction, SortValue.NullOrdering nullOrdering, int limit) {
        SortValue order = new SortValue(ref, direction, nullOrdering);
        this.orders = Collections.singletonList(order);
        this.limit = limit;
    }

    public List<SortValue> orders() {
        return this.orders;
    }

    public int limit() {
        return this.limit;
    }

    public String toString() {
        String sort = this.orders.stream().map(SortValue::toString).collect(Collectors.joining(", "));
        return String.format("Sort(%s), Limit(%s)", sort, this.limit);
    }
}

