/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import javax.annotation.Nullable;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.VarCharType;

public class DefaultValueUtils {
    public static Object convertDefaultValue(DataType dataType, String defaultValueStr) {
        CastExecutor<?, ?> resolve = CastExecutors.resolve(VarCharType.STRING_TYPE, dataType);
        if (resolve == null) {
            throw new RuntimeException("Default value do not support the type of " + dataType);
        }
        if (defaultValueStr.startsWith("'") && defaultValueStr.endsWith("'")) {
            defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1);
        }
        return resolve.cast(BinaryString.fromString(defaultValueStr));
    }

    public static void validateDefaultValue(DataType dataType, @Nullable String defaultValueStr) {
        if (defaultValueStr == null) {
            return;
        }
        try {
            DefaultValueUtils.convertDefaultValue(dataType, defaultValueStr);
        }
        catch (Exception e) {
            throw new RuntimeException("Unsupported default value `" + defaultValueStr + "` for type " + dataType, e);
        }
    }
}

