/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;

public class SpecialFields {
    public static final int SYSTEM_FIELD_ID_START = 0x3FFFFFFF;
    public static final String KEY_FIELD_PREFIX = "_KEY_";
    public static final int KEY_FIELD_ID_START = 0x3FFFFFFF;
    public static final DataField SEQUENCE_NUMBER = new DataField(0x7FFFFFFE, "_SEQUENCE_NUMBER", DataTypes.BIGINT().notNull());
    public static final DataField VALUE_KIND = new DataField(0x7FFFFFFD, "_VALUE_KIND", DataTypes.TINYINT().notNull());
    public static final DataField LEVEL = new DataField(0x7FFFFFFC, "_LEVEL", DataTypes.INT().notNull());
    public static final DataField ROW_KIND = new DataField(0x7FFFFFFB, "rowkind", new VarCharType(Integer.MAX_VALUE));
    public static final DataField ROW_ID = new DataField(0x7FFFFFFA, "_ROW_ID", DataTypes.BIGINT());
    public static final Set<String> SYSTEM_FIELD_NAMES = Stream.of(SEQUENCE_NUMBER.name(), VALUE_KIND.name(), LEVEL.name(), ROW_KIND.name(), ROW_ID.name()).collect(Collectors.toSet());
    public static final int STRUCTURED_TYPE_FIELD_ID_BASE = 0x1FFFFFFF;
    public static final int STRUCTURED_TYPE_FIELD_DEPTH_LIMIT = 1024;

    public static boolean isSystemField(int fieldId) {
        return fieldId >= 0x3FFFFFFF;
    }

    public static boolean isSystemField(String field) {
        return field.startsWith(KEY_FIELD_PREFIX) || SYSTEM_FIELD_NAMES.contains(field);
    }

    public static boolean isKeyField(String field) {
        return field.startsWith(KEY_FIELD_PREFIX);
    }

    public static int getArrayElementFieldId(int arrayFieldId, int depth) {
        return 0x1FFFFFFF + arrayFieldId * 1024 + depth;
    }

    public static int getMapKeyFieldId(int mapFieldId, int depth) {
        return 0x1FFFFFFF - mapFieldId * 1024 - depth;
    }

    public static int getMapValueFieldId(int mapFieldId, int depth) {
        return 0x1FFFFFFF + mapFieldId * 1024 + depth;
    }

    public static RowType rowTypeWithRowTracking(RowType rowType) {
        return SpecialFields.rowTypeWithRowTracking(rowType, false);
    }

    public static RowType rowTypeWithRowTracking(RowType rowType, boolean sequenceNumberNullable) {
        ArrayList<DataField> fieldsWithRowTracking = new ArrayList<DataField>(rowType.getFields());
        fieldsWithRowTracking.forEach(f -> {
            if (ROW_ID.name().equals(f.name()) || SEQUENCE_NUMBER.name().equals(f.name())) {
                throw new IllegalArgumentException("Row tracking field name '" + f.name() + "' conflicts with existing field names.");
            }
        });
        fieldsWithRowTracking.add(ROW_ID);
        fieldsWithRowTracking.add(sequenceNumberNullable ? SEQUENCE_NUMBER.copy(true) : SEQUENCE_NUMBER);
        return new RowType(fieldsWithRowTracking);
    }
}

