/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="occ", aliases={"ozone-client-creator"}, description={"Create and close Ozone clients without doing anything useful"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientCreator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID;
    private Timer timer;
    private OzoneConfiguration conf;

    @Override
    public Void call() {
        this.init();
        this.conf = this.createOzoneConfiguration();
        this.timer = this.getMetrics().timer("client-create");
        this.runTests(this::createClient);
        return null;
    }

    private void createClient(long step) {
        this.timer.time(this::createClientSafely);
    }

    private void createClientSafely() {
        try {
            this.createOzoneClient(this.omServiceID, this.conf).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

