/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import picocli.CommandLine;

@CommandLine.Command(name="fetch-key", description={"CLI command to force OM to fetch the latest secret key from SCM."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class FetchKeySubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID"}, required=false)
    private String omServiceId;

    @Override
    public Void call() throws Exception {
        try (OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId);){
            UUID uuid = client.refetchSecretKey();
            System.out.println("Current Secret Key ID: " + uuid);
        }
        return null;
    }
}

