/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3secret;

import java.io.IOException;
import java.security.Principal;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.ozone.s3secret.S3AdminEndpoint;
import org.apache.hadoop.security.UserGroupInformation;

@S3AdminEndpoint
@Provider
public class S3SecretAdminFilter
implements ContainerRequestFilter {
    @Inject
    private OzoneConfiguration conf;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UserGroupInformation user;
        Principal userPrincipal = requestContext.getSecurityContext().getUserPrincipal();
        if (null != userPrincipal && !OzoneAdmins.isS3Admin((UserGroupInformation)(user = UserGroupInformation.createRemoteUser((String)userPrincipal.getName())), (OzoneConfiguration)this.conf)) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }
}

