/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import org.apache.hadoop.ozone.s3.signature.MalformedResourceException;

public class Credential {
    private String accessKeyID;
    private String date;
    private String awsRegion;
    private String awsService;
    private String awsRequest;
    private String credential;

    Credential(String cred) throws MalformedResourceException {
        this.credential = cred;
        this.parseCredential();
    }

    public void parseCredential() throws MalformedResourceException {
        String[] split = this.credential.split("/");
        switch (split.length) {
            case 5: {
                this.accessKeyID = split[0].trim();
                this.date = split[1].trim();
                this.awsRegion = split[2].trim();
                this.awsService = split[3].trim();
                this.awsRequest = split[4].trim();
                return;
            }
            case 6: {
                this.accessKeyID = split[0] + "/" + split[1];
                this.date = split[2].trim();
                this.awsRegion = split[3].trim();
                this.awsService = split[4].trim();
                this.awsRequest = split[5].trim();
                return;
            }
        }
        throw new MalformedResourceException("Credentials not in expected format.", this.credential);
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public String getDate() {
        return this.date;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsService() {
        return this.awsService;
    }

    public String getAwsRequest() {
        return this.awsRequest;
    }

    public String getCredential() {
        return this.credential;
    }

    public String createScope() {
        return String.format("%s/%s/%s/%s", this.getDate(), this.getAwsRegion(), this.getAwsService(), this.getAwsRequest());
    }
}

