/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.ozone.s3.RequestIdentifier;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class OS3ExceptionMapper
implements ExceptionMapper<OS3Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(OS3ExceptionMapper.class);
    @Inject
    private RequestIdentifier requestIdentifier;

    public Response toResponse(OS3Exception exception) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning exception. ex: {}", (Object)exception.toString());
        }
        exception.setRequestId(this.requestIdentifier.getRequestId());
        return Response.status((int)exception.getHttpCode()).entity((Object)exception.toXml()).build();
    }
}

