/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureProcessor;
import org.apache.hadoop.ozone.s3.signature.StringToSignProducer;
import org.apache.hadoop.ozone.s3.util.S3Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@Priority(value=50)
public class AuthorizationFilter
implements ContainerRequestFilter {
    public static final int PRIORITY = 50;
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationFilter.class);
    @Inject
    private SignatureProcessor signatureProcessor;
    @Inject
    private SignatureInfo signatureInfo;

    public void filter(ContainerRequestContext context) throws IOException {
        try {
            this.signatureInfo.initialize(this.signatureProcessor.parseSignature());
            if (this.signatureInfo.getVersion() != SignatureInfo.Version.V4) {
                LOG.debug("Unsupported AWS signature version: {}", (Object)this.signatureInfo.getVersion());
                throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
            }
            this.signatureInfo.setStrToSign(StringToSignProducer.createSignatureBase(this.signatureInfo, context));
            String awsAccessId = this.signatureInfo.getAwsAccessId();
            if (awsAccessId == null || awsAccessId.equals("")) {
                LOG.debug("Malformed s3 header. awsAccessID: {}", (Object)awsAccessId);
                throw S3ErrorTable.ACCESS_DENIED;
            }
        }
        catch (OS3Exception ex) {
            LOG.debug("Error during Client Creation: ", (Throwable)ex);
            throw S3Utils.wrapOS3Exception(ex);
        }
        catch (Exception e) {
            LOG.debug("Error during Client Creation: ", (Throwable)e);
            throw S3Utils.wrapOS3Exception(S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, null, e));
        }
    }

    @VisibleForTesting
    public void setSignatureParser(SignatureProcessor awsSignatureProcessor) {
        this.signatureProcessor = awsSignatureProcessor;
    }

    @VisibleForTesting
    public void setSignatureInfo(SignatureInfo signatureInfo) {
        this.signatureInfo = signatureInfo;
    }

    @VisibleForTesting
    public SignatureInfo getSignatureInfo() {
        return this.signatureInfo;
    }
}

