/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.S3GAction;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.s3.SignedChunksInputStream;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadRequest;
import org.apache.hadoop.ozone.s3.endpoint.CompleteMultipartUploadResponse;
import org.apache.hadoop.ozone.s3.endpoint.CopyObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.CopyPartResult;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListPartsResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpointStreaming;
import org.apache.hadoop.ozone.s3.endpoint.PutTaggingUnmarshaller;
import org.apache.hadoop.ozone.s3.endpoint.S3Tagging;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.RFC1123Util;
import org.apache.hadoop.ozone.s3.util.RangeHeader;
import org.apache.hadoop.ozone.s3.util.RangeHeaderParserUtil;
import org.apache.hadoop.ozone.s3.util.S3Consts;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.s3.util.S3Utils;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}/{path:.+}")
public class ObjectEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectEndpoint.class);
    private static final ThreadLocal<MessageDigest> E_TAG_PROVIDER = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    @Context
    private ContainerRequestContext context;
    @Context
    private HttpHeaders headers;
    private Map<String, String> overrideQueryParameter = ImmutableMap.builder().put((Object)"Content-Type", (Object)"response-content-type").put((Object)"Content-Language", (Object)"response-content-language").put((Object)"Expires", (Object)"response-expires").put((Object)"Cache-Control", (Object)"response-cache-control").put((Object)"Content-Disposition", (Object)"response-content-disposition").put((Object)"Content-Encoding", (Object)"response-content-encoding").build();
    private int bufferSize;
    private int chunkSize;
    private boolean datastreamEnabled;
    private long datastreamMinLength;
    @Inject
    private OzoneConfiguration ozoneConfiguration;

    @Override
    @PostConstruct
    public void init() {
        this.bufferSize = (int)this.ozoneConfiguration.getStorageSize("ozone.s3g.client.buffer.size", "4MB", StorageUnit.BYTES);
        this.chunkSize = (int)this.ozoneConfiguration.getStorageSize("ozone.scm.chunk.size", "4MB", StorageUnit.BYTES);
        this.datastreamEnabled = this.ozoneConfiguration.getBoolean("hdds.container.ratis.datastream.enabled", false);
        this.datastreamMinLength = (long)this.ozoneConfiguration.getStorageSize("ozone.fs.datastream.auto.threshold", "4MB", StorageUnit.BYTES);
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @HeaderParam(value="Content-Length") long length, @QueryParam(value="partNumber") int partNumber, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadID, @QueryParam(value="tagging") String taggingMarker, @QueryParam(value="acl") String aclMarker, InputStream body) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.CREATE_KEY;
        boolean auditSuccess = true;
        AuditLogger.PerformanceStringBuilder perf = new AuditLogger.PerformanceStringBuilder();
        String copyHeader = null;
        String storageType = null;
        DigestInputStream digestInputStream = null;
        try {
            long putLength;
            boolean hasAmzDecodedLengthZero;
            if (aclMarker != null) {
                s3GAction = S3GAction.PUT_OBJECT_ACL;
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, keyPath);
            }
            OzoneVolume volume = this.getVolume();
            if (taggingMarker != null) {
                s3GAction = S3GAction.PUT_OBJECT_TAGGING;
                Response response = this.putObjectTagging(volume, bucketName, keyPath, body);
                return response;
            }
            if (uploadID != null && !uploadID.equals("")) {
                s3GAction = this.headers.getHeaderString("x-amz-copy-source") == null ? S3GAction.CREATE_MULTIPART_KEY : S3GAction.CREATE_MULTIPART_KEY_BY_COPY;
                Response response = this.createMultipartKey(volume, bucketName, keyPath, length, partNumber, uploadID, body, perf);
                return response;
            }
            copyHeader = this.headers.getHeaderString("x-amz-copy-source");
            storageType = this.headers.getHeaderString("x-amz-storage-class");
            boolean storageTypeDefault = StringUtils.isEmpty((CharSequence)storageType);
            OzoneBucket bucket = volume.getBucket(bucketName);
            ReplicationConfig replicationConfig = this.getReplicationConfig(bucket, storageType);
            boolean enableEC = false;
            if (replicationConfig != null && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC || bucket.getReplicationConfig() instanceof ECReplicationConfig) {
                enableEC = true;
            }
            if (copyHeader != null) {
                s3GAction = S3GAction.COPY_OBJECT;
                CopyObjectResponse copyObjectResponse = this.copyObject(volume, copyHeader, bucketName, keyPath, replicationConfig, storageTypeDefault, perf);
                Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)copyObjectResponse).header("Connection", (Object)"close").build();
                return response;
            }
            boolean canCreateDirectory = this.ozoneConfiguration.getBoolean("ozone.s3g.fso.directory.creation", true) && bucket.getBucketLayout() == BucketLayout.FILE_SYSTEM_OPTIMIZED;
            String amzDecodedLength = this.headers.getHeaderString("x-amz-decoded-content-length");
            boolean bl = hasAmzDecodedLengthZero = amzDecodedLength != null && Long.parseLong(amzDecodedLength) == 0L;
            if (canCreateDirectory && (length == 0L || hasAmzDecodedLengthZero) && StringUtils.endsWith((CharSequence)keyPath, (CharSequence)"/")) {
                s3GAction = S3GAction.CREATE_DIRECTORY;
                this.getClientProtocol().createDirectory(volume.getName(), bucketName, keyPath);
                long metadataLatencyNs = this.getMetrics().updatePutKeyMetadataStats(startNanos);
                perf.appendMetaLatencyNanos(metadataLatencyNs);
                Response response = Response.ok().status(200).build();
                return response;
            }
            Map<String, String> customMetadata = this.getCustomMetadataFromHeaders((MultivaluedMap<String, String>)this.headers.getRequestHeaders());
            if (S3Utils.hasSignedPayloadHeader(this.headers)) {
                digestInputStream = new DigestInputStream(new SignedChunksInputStream(body), this.getMessageDigestInstance());
                length = Long.parseLong(amzDecodedLength);
            } else {
                digestInputStream = new DigestInputStream(body, this.getMessageDigestInstance());
            }
            Map<String, String> tags = this.getTaggingFromHeaders(this.headers);
            String eTag = null;
            if (this.datastreamEnabled && !enableEC && length > this.datastreamMinLength) {
                perf.appendStreamMode();
                Pair<String, Long> keyWriteResult = ObjectEndpointStreaming.put(bucket, keyPath, length, replicationConfig, this.chunkSize, customMetadata, tags, digestInputStream, perf);
                eTag = (String)keyWriteResult.getKey();
                putLength = (Long)keyWriteResult.getValue();
            } else {
                try (OzoneOutputStream output = this.getClientProtocol().createKey(volume.getName(), bucketName, keyPath, length, replicationConfig, customMetadata, tags);){
                    long metadataLatencyNs = this.getMetrics().updatePutKeyMetadataStats(startNanos);
                    perf.appendMetaLatencyNanos(metadataLatencyNs);
                    putLength = IOUtils.copyLarge((InputStream)digestInputStream, (OutputStream)output, (long)0L, (long)length, (byte[])new byte[this.getIOBufferSize(length)]);
                    eTag = DatatypeConverter.printHexBinary((byte[])digestInputStream.getMessageDigest().digest()).toLowerCase();
                    output.getMetadata().put("ETag", eTag);
                }
            }
            this.getMetrics().incPutKeySuccessLength(putLength);
            perf.appendSizeBytes(putLength);
            Response response = Response.ok().header("ETag", (Object)ObjectEndpoint.wrapInQuotes(eTag)).status(200).build();
            return response;
        }
        catch (OMException ex) {
            auditSuccess = false;
            this.auditWriteFailure(s3GAction, ex);
            if (taggingMarker != null) {
                this.getMetrics().updatePutObjectTaggingFailureStats(startNanos);
            } else if (copyHeader != null) {
                this.getMetrics().updateCopyObjectFailureStats(startNanos);
            } else {
                this.getMetrics().updateCreateKeyFailureStats(startNanos);
            }
            if (ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, keyPath, (Exception)((Object)ex));
                os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the PutObject/MPU PartUpload operation: ozone.om.enable.filesystem.paths is enabled Keys are considered as Unix Paths. Path has Violated FS Semantics which caused put operation to fail.");
                throw os3Exception;
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.QUOTA_EXCEEDED) {
                throw S3ErrorTable.newError(S3ErrorTable.QUOTA_EXCEEDED, keyPath, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.FILE_ALREADY_EXISTS) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_OVERWRITE, keyPath, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            auditSuccess = false;
            this.auditWriteFailure(s3GAction, ex);
            if (aclMarker != null) {
                this.getMetrics().updatePutObjectAclFailureStats(startNanos);
            } else if (taggingMarker != null) {
                this.getMetrics().updatePutObjectTaggingFailureStats(startNanos);
            } else if (copyHeader != null) {
                this.getMetrics().updateCopyObjectFailureStats(startNanos);
            } else {
                this.getMetrics().updateCreateKeyFailureStats(startNanos);
            }
            throw ex;
        }
        finally {
            if (digestInputStream != null) {
                digestInputStream.getMessageDigest().reset();
            }
            if (auditSuccess) {
                long opLatencyNs = this.getMetrics().updateCreateKeySuccessStats(startNanos);
                perf.appendOpLatencyNanos(opLatencyNs);
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters(), perf));
            }
        }
    }

    @GET
    public Response get(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @QueryParam(value="partNumber") int partNumber, @QueryParam(value="uploadId") String uploadId, @QueryParam(value="max-parts") @DefaultValue(value="1000") int maxParts, @QueryParam(value="part-number-marker") String partNumberMarker, @QueryParam(value="tagging") String taggingMarker) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.GET_KEY;
        AuditLogger.PerformanceStringBuilder perf = new AuditLogger.PerformanceStringBuilder();
        try {
            Response.ResponseBuilder responseBuilder;
            if (taggingMarker != null) {
                s3GAction = S3GAction.GET_OBJECT_TAGGING;
                return this.getObjectTagging(bucketName, keyPath);
            }
            if (uploadId != null) {
                s3GAction = S3GAction.LIST_PARTS;
                int partMarker = ObjectEndpoint.parsePartNumberMarker(partNumberMarker);
                Response response = this.listParts(bucketName, keyPath, uploadId, partMarker, maxParts, perf);
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters(), perf));
                return response;
            }
            OzoneKeyDetails keyDetails = partNumber != 0 ? this.getClientProtocol().getS3KeyDetails(bucketName, keyPath, partNumber) : this.getClientProtocol().getS3KeyDetails(bucketName, keyPath);
            this.isFile(keyPath, (OzoneKey)keyDetails);
            long length = keyDetails.getDataSize();
            LOG.debug("Data length of the key {} is {}", (Object)keyPath, (Object)length);
            String rangeHeaderVal = this.headers.getHeaderString("Range");
            RangeHeader rangeHeader = null;
            LOG.debug("range Header provided value: {}", (Object)rangeHeaderVal);
            if (rangeHeaderVal != null) {
                rangeHeader = RangeHeaderParserUtil.parseRangeHeader(rangeHeaderVal, length);
                LOG.debug("range Header provided: {}", (Object)rangeHeader);
                if (rangeHeader.isInValidRange()) {
                    throw S3ErrorTable.newError(S3ErrorTable.INVALID_RANGE, rangeHeaderVal);
                }
            }
            if (rangeHeaderVal == null || rangeHeader.isReadFull()) {
                StreamingOutput output = dest -> {
                    try (OzoneInputStream key = keyDetails.getContent();){
                        long readLength = IOUtils.copy((InputStream)key, (OutputStream)dest, (int)this.getIOBufferSize(keyDetails.getDataSize()));
                        this.getMetrics().incGetKeySuccessLength(readLength);
                        perf.appendSizeBytes(readLength);
                    }
                    long opLatencyNs = this.getMetrics().updateGetKeySuccessStats(startNanos);
                    perf.appendOpLatencyNanos(opLatencyNs);
                    AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(S3GAction.GET_KEY, this.getAuditParameters(), perf));
                };
                responseBuilder = Response.ok((Object)output).header("Content-Length", (Object)keyDetails.getDataSize());
            } else {
                long startOffset = rangeHeader.getStartOffset();
                long endOffset = rangeHeader.getEndOffset();
                long copyLength = endOffset - startOffset + 1L;
                StreamingOutput output = dest -> {
                    try (OzoneInputStream ozoneInputStream = keyDetails.getContent();){
                        ozoneInputStream.seek(startOffset);
                        long readLength = IOUtils.copyLarge((InputStream)ozoneInputStream, (OutputStream)dest, (long)0L, (long)copyLength, (byte[])new byte[this.getIOBufferSize(copyLength)]);
                        this.getMetrics().incGetKeySuccessLength(readLength);
                        perf.appendSizeBytes(readLength);
                    }
                    long opLatencyNs = this.getMetrics().updateGetKeySuccessStats(startNanos);
                    perf.appendOpLatencyNanos(opLatencyNs);
                    AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(S3GAction.GET_KEY, this.getAuditParameters(), perf));
                };
                responseBuilder = Response.status((Response.Status)Response.Status.PARTIAL_CONTENT).entity((Object)output).header("Content-Length", (Object)copyLength);
                String contentRangeVal = "bytes " + rangeHeader.getStartOffset() + "-" + rangeHeader.getEndOffset() + "/" + length;
                responseBuilder.header("Content-Range", (Object)contentRangeVal);
            }
            responseBuilder.header("Accept-Ranges", (Object)"bytes");
            String eTag = (String)keyDetails.getMetadata().get("ETag");
            if (eTag != null) {
                responseBuilder.header("ETag", (Object)ObjectEndpoint.wrapInQuotes(eTag));
                String partsCount = this.extractPartsCount(eTag);
                if (partsCount != null) {
                    responseBuilder.header("x-amz-mp-parts-count", (Object)partsCount);
                }
            }
            MultivaluedMap queryParams = this.context.getUriInfo().getQueryParameters();
            for (Map.Entry<String, String> entry : this.overrideQueryParameter.entrySet()) {
                String headerValue = this.headers.getHeaderString(entry.getKey());
                String queryValue = (String)queryParams.getFirst((Object)entry.getValue());
                if (queryValue != null) {
                    headerValue = queryValue;
                }
                if (headerValue == null) continue;
                responseBuilder.header(entry.getKey(), (Object)headerValue);
            }
            ObjectEndpoint.addLastModifiedDate(responseBuilder, (OzoneKey)keyDetails);
            ObjectEndpoint.addTagCountIfAny(responseBuilder, (OzoneKey)keyDetails);
            long metadataLatencyNs = this.getMetrics().updateGetKeyMetadataStats(startNanos);
            perf.appendMetaLatencyNanos(metadataLatencyNs);
            return responseBuilder.build();
        }
        catch (OMException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            if (taggingMarker != null) {
                this.getMetrics().updateGetObjectTaggingFailureStats(startNanos);
            } else if (uploadId != null) {
                this.getMetrics().updateListPartsFailureStats(startNanos);
            } else {
                this.getMetrics().updateGetKeyFailureStats(startNanos);
            }
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, keyPath, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
    }

    static void addLastModifiedDate(Response.ResponseBuilder responseBuilder, OzoneKey key) {
        ZonedDateTime lastModificationTime = key.getModificationTime().atZone(ZoneId.of("GMT"));
        responseBuilder.header("Last-Modified", (Object)RFC1123Util.FORMAT.format(lastModificationTime));
    }

    static void addTagCountIfAny(Response.ResponseBuilder responseBuilder, OzoneKey key) {
        if (!key.getTags().isEmpty()) {
            responseBuilder.header("x-amz-tagging-count", (Object)key.getTags().size());
        }
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath) throws IOException, OS3Exception {
        OzoneKey key;
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.HEAD_KEY;
        try {
            key = this.getClientProtocol().headS3Object(bucketName, keyPath);
            this.isFile(keyPath, key);
        }
        catch (OMException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            this.getMetrics().updateHeadKeyFailureStats(startNanos);
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
        Response.ResponseBuilder response = Response.ok().status(200).header("Content-Length", (Object)key.getDataSize()).header("Content-Type", (Object)"binary/octet-stream");
        String eTag = (String)key.getMetadata().get("ETag");
        if (eTag != null) {
            response.header("ETag", (Object)ObjectEndpoint.wrapInQuotes(eTag));
            String partsCount = this.extractPartsCount(eTag);
            if (partsCount != null) {
                response.header("x-amz-mp-parts-count", (Object)partsCount);
            }
        }
        ObjectEndpoint.addLastModifiedDate(response, key);
        this.addCustomMetadataHeaders(response, key);
        this.getMetrics().updateHeadKeySuccessStats(startNanos);
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
        return response.build();
    }

    private void isFile(String keyPath, OzoneKey key) throws OMException {
        boolean isFsoDirCreationEnabled = this.ozoneConfiguration.getBoolean("ozone.s3g.fso.directory.creation", true);
        if (isFsoDirCreationEnabled && !key.isFile() && !keyPath.endsWith("/")) {
            throw new OMException(OMException.ResultCodes.KEY_NOT_FOUND);
        }
    }

    private Response abortMultipartUpload(OzoneVolume volume, String bucket, String key, String uploadId) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        try {
            this.getClientProtocol().abortMultipartUpload(volume.getName(), bucket, key, uploadId);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadId, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucket, (Exception)((Object)ex));
            }
            throw ex;
        }
        this.getMetrics().updateAbortMultipartUploadSuccessStats(startNanos);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName, @PathParam(value="path") String keyPath, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadId, @QueryParam(value="tagging") String taggingMarker) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.DELETE_KEY;
        try {
            OzoneVolume volume = this.getVolume();
            if (taggingMarker != null) {
                s3GAction = S3GAction.DELETE_OBJECT_TAGGING;
                return this.deleteObjectTagging(volume, bucketName, keyPath);
            }
            if (uploadId != null && !uploadId.equals("")) {
                s3GAction = S3GAction.ABORT_MULTIPART_UPLOAD;
                return this.abortMultipartUpload(volume, bucketName, keyPath, uploadId);
            }
            this.getClientProtocol().deleteKey(volume.getName(), bucketName, keyPath, false);
        }
        catch (OMException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            if (uploadId != null && !uploadId.equals("")) {
                this.getMetrics().updateAbortMultipartUploadFailureStats(startNanos);
            } else {
                this.getMetrics().updateDeleteKeyFailureStats(startNanos);
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() != OMException.ResultCodes.KEY_NOT_FOUND && ex.getResult() != OMException.ResultCodes.DIRECTORY_NOT_EMPTY) {
                if (this.isAccessDenied(ex)) {
                    throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyPath, (Exception)((Object)ex));
                }
                if (ex.getResult() == OMException.ResultCodes.NOT_SUPPORTED_OPERATION) {
                    throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, keyPath);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            if (taggingMarker != null) {
                this.getMetrics().updateDeleteObjectTaggingFailureStats(startNanos);
            } else if (uploadId != null && !uploadId.equals("")) {
                this.getMetrics().updateAbortMultipartUploadFailureStats(startNanos);
            } else {
                this.getMetrics().updateDeleteKeyFailureStats(startNanos);
            }
            throw ex;
        }
        this.getMetrics().updateDeleteKeySuccessStats(startNanos);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"ozone/mpu"})
    public Response initializeMultipartUpload(@PathParam(value="bucket") String bucket, @PathParam(value="path") String key) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.INIT_MULTIPART_UPLOAD;
        try {
            OzoneBucket ozoneBucket = this.getBucket(bucket);
            String storageType = this.headers.getHeaderString("x-amz-storage-class");
            Map<String, String> customMetadata = this.getCustomMetadataFromHeaders((MultivaluedMap<String, String>)this.headers.getRequestHeaders());
            Map<String, String> tags = this.getTaggingFromHeaders(this.headers);
            ReplicationConfig replicationConfig = this.getReplicationConfig(ozoneBucket, storageType);
            OmMultipartInfo multipartInfo = ozoneBucket.initiateMultipartUpload(key, replicationConfig, customMetadata, tags);
            MultipartUploadInitiateResponse multipartUploadInitiateResponse = new MultipartUploadInitiateResponse();
            multipartUploadInitiateResponse.setBucket(bucket);
            multipartUploadInitiateResponse.setKey(key);
            multipartUploadInitiateResponse.setUploadID(multipartInfo.getUploadID());
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
            this.getMetrics().updateInitMultipartUploadSuccessStats(startNanos);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)multipartUploadInitiateResponse).build();
        }
        catch (OMException ex) {
            this.auditWriteFailure(s3GAction, ex);
            this.getMetrics().updateInitMultipartUploadFailureStats(startNanos);
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, key, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            this.getMetrics().updateInitMultipartUploadFailureStats(startNanos);
            throw ex;
        }
    }

    private ReplicationConfig getReplicationConfig(OzoneBucket ozoneBucket, String storageType) throws OS3Exception {
        if (StringUtils.isEmpty((CharSequence)storageType)) {
            S3StorageType defaultStorageType = S3StorageType.getDefault((ConfigurationSource)this.ozoneConfiguration);
            storageType = defaultStorageType != null ? defaultStorageType.toString() : null;
        }
        ReplicationConfig clientConfiguredReplicationConfig = null;
        String replication = this.ozoneConfiguration.get("ozone.replication");
        if (replication != null) {
            clientConfiguredReplicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)this.ozoneConfiguration.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT)), (String)replication, (ConfigurationSource)this.ozoneConfiguration);
        }
        return S3Utils.resolveS3ClientSideReplicationConfig(storageType, clientConfiguredReplicationConfig, ozoneBucket.getReplicationConfig());
    }

    @POST
    @Produces(value={"application/xml"})
    public Response completeMultipartUpload(@PathParam(value="bucket") String bucket, @PathParam(value="path") String key, @QueryParam(value="uploadId") @DefaultValue(value="") String uploadID, CompleteMultipartUploadRequest multipartUploadRequest) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.COMPLETE_MULTIPART_UPLOAD;
        OzoneVolume volume = this.getVolume();
        LinkedHashMap<Integer, String> partsMap = new LinkedHashMap<Integer, String>();
        List<CompleteMultipartUploadRequest.Part> partList = multipartUploadRequest.getPartList();
        try {
            for (CompleteMultipartUploadRequest.Part part : partList) {
                partsMap.put(part.getPartNumber(), part.getETag());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parts map {}", partsMap);
            }
            OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.getClientProtocol().completeMultipartUpload(volume.getName(), bucket, key, uploadID, partsMap);
            CompleteMultipartUploadResponse completeMultipartUploadResponse = new CompleteMultipartUploadResponse();
            completeMultipartUploadResponse.setBucket(bucket);
            completeMultipartUploadResponse.setKey(key);
            completeMultipartUploadResponse.setETag(ObjectEndpoint.wrapInQuotes(omMultipartUploadCompleteInfo.getHash()));
            completeMultipartUploadResponse.setLocation(bucket);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
            this.getMetrics().updateCompleteMultipartUploadSuccessStats(startNanos);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)completeMultipartUploadResponse).build();
        }
        catch (OMException ex) {
            this.auditWriteFailure(s3GAction, ex);
            this.getMetrics().updateCompleteMultipartUploadFailureStats(startNanos);
            if (ex.getResult() == OMException.ResultCodes.INVALID_PART) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_PART, key, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_PART_ORDER) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_PART_ORDER, key, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.ENTITY_TOO_SMALL) {
                throw S3ErrorTable.newError(S3ErrorTable.ENTITY_TOO_SMALL, key, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_REQUEST) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, key, (Exception)((Object)ex));
                os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the CompleteMultipartUpload operation: You must specify at least one part");
                throw os3Exception;
            }
            if (ex.getResult() == OMException.ResultCodes.NOT_A_FILE) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, key, (Exception)((Object)ex));
                os3Exception.setErrorMessage("An error occurred (InvalidRequest) when calling the CompleteMultipartUpload operation: ozone.om.enable.filesystem.paths is enabled Keys are considered as Unix Paths. A directory already exists with a given KeyName caused failure for MPU");
                throw os3Exception;
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucket, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            this.auditWriteFailure(s3GAction, ex);
            throw ex;
        }
    }

    private Response createMultipartKey(OzoneVolume volume, String bucket, String key, long length, int partNumber, String uploadID, InputStream body, AuditLogger.PerformanceStringBuilder perf) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        String copyHeader = null;
        DigestInputStream digestInputStream = null;
        try {
            Response response;
            long putLength;
            OzoneOutputStream outputStream;
            long metadataLatencyNs;
            if (S3Utils.hasSignedPayloadHeader(this.headers)) {
                digestInputStream = new DigestInputStream(new SignedChunksInputStream(body), this.getMessageDigestInstance());
                length = Long.parseLong(this.headers.getHeaderString("x-amz-decoded-content-length"));
            } else {
                digestInputStream = new DigestInputStream(body, this.getMessageDigestInstance());
            }
            copyHeader = this.headers.getHeaderString("x-amz-copy-source");
            String storageType = this.headers.getHeaderString("x-amz-storage-class");
            OzoneBucket ozoneBucket = volume.getBucket(bucket);
            ReplicationConfig replicationConfig = this.getReplicationConfig(ozoneBucket, storageType);
            boolean enableEC = false;
            if (replicationConfig != null && replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC || ozoneBucket.getReplicationConfig() instanceof ECReplicationConfig) {
                enableEC = true;
            }
            if (this.datastreamEnabled && !enableEC && copyHeader == null) {
                perf.appendStreamMode();
                Response response2 = ObjectEndpointStreaming.createMultipartKey(ozoneBucket, key, length, partNumber, uploadID, this.chunkSize, digestInputStream, perf);
                return response2;
            }
            if (copyHeader != null) {
                Pair<String, String> result = ObjectEndpoint.parseSourceHeader(copyHeader);
                String sourceBucket = (String)result.getLeft();
                String sourceKey = (String)result.getRight();
                OzoneKeyDetails sourceKeyDetails = this.getClientProtocol().getKeyDetails(volume.getName(), sourceBucket, sourceKey);
                String range = this.headers.getHeaderString("x-amz-copy-source-range");
                RangeHeader rangeHeader = null;
                if (range != null) {
                    rangeHeader = RangeHeaderParserUtil.parseRangeHeader(range, 0L);
                    length = rangeHeader.getEndOffset() - rangeHeader.getStartOffset() + 1L;
                } else {
                    length = sourceKeyDetails.getDataSize();
                }
                Long sourceKeyModificationTime = sourceKeyDetails.getModificationTime().toEpochMilli();
                String copySourceIfModifiedSince = this.headers.getHeaderString("x-amz-copy-source-if-modified-since");
                String copySourceIfUnmodifiedSince = this.headers.getHeaderString("x-amz-copy-source-if-unmodified-since");
                if (!ObjectEndpoint.checkCopySourceModificationTime(sourceKeyModificationTime, copySourceIfModifiedSince, copySourceIfUnmodifiedSince)) {
                    throw S3ErrorTable.newError(S3ErrorTable.PRECOND_FAILED, sourceBucket + "/" + sourceKey);
                }
                try (OzoneInputStream sourceObject = sourceKeyDetails.getContent();){
                    long copyLength;
                    if (range != null) {
                        long skipped = sourceObject.skip(rangeHeader.getStartOffset());
                        if (skipped != rangeHeader.getStartOffset()) {
                            throw new EOFException("Bytes to skip: " + rangeHeader.getStartOffset() + " actual: " + skipped);
                        }
                        try (OzoneOutputStream ozoneOutputStream = this.getClientProtocol().createMultipartKey(volume.getName(), bucket, key, length, partNumber, uploadID);){
                            metadataLatencyNs = this.getMetrics().updateCopyKeyMetadataStats(startNanos);
                            copyLength = IOUtils.copyLarge((InputStream)sourceObject, (OutputStream)ozoneOutputStream, (long)0L, (long)length, (byte[])new byte[this.getIOBufferSize(length)]);
                            ozoneOutputStream.getMetadata().putAll(sourceKeyDetails.getMetadata());
                            outputStream = ozoneOutputStream;
                        }
                    }
                    try (OzoneOutputStream ozoneOutputStream = this.getClientProtocol().createMultipartKey(volume.getName(), bucket, key, length, partNumber, uploadID);){
                        metadataLatencyNs = this.getMetrics().updateCopyKeyMetadataStats(startNanos);
                        copyLength = IOUtils.copyLarge((InputStream)sourceObject, (OutputStream)ozoneOutputStream, (long)0L, (long)length, (byte[])new byte[this.getIOBufferSize(length)]);
                        ozoneOutputStream.getMetadata().putAll(sourceKeyDetails.getMetadata());
                        outputStream = ozoneOutputStream;
                    }
                    this.getMetrics().incCopyObjectSuccessLength(copyLength);
                    perf.appendSizeBytes(copyLength);
                }
            }
            try (OzoneOutputStream ozoneOutputStream = this.getClientProtocol().createMultipartKey(volume.getName(), bucket, key, length, partNumber, uploadID);){
                metadataLatencyNs = this.getMetrics().updatePutKeyMetadataStats(startNanos);
                putLength = IOUtils.copyLarge((InputStream)digestInputStream, (OutputStream)ozoneOutputStream, (long)0L, (long)length, (byte[])new byte[this.getIOBufferSize(length)]);
                byte[] digest = digestInputStream.getMessageDigest().digest();
                ozoneOutputStream.getMetadata().put("ETag", DatatypeConverter.printHexBinary((byte[])digest).toLowerCase());
                outputStream = ozoneOutputStream;
            }
            this.getMetrics().incPutKeySuccessLength(putLength);
            perf.appendSizeBytes(putLength);
            perf.appendMetaLatencyNanos(metadataLatencyNs);
            OmMultipartCommitUploadPartInfo omMultipartCommitUploadPartInfo = outputStream.getCommitUploadPartInfo();
            String eTag = omMultipartCommitUploadPartInfo.getETag();
            if (StringUtils.isEmpty((CharSequence)eTag)) {
                eTag = omMultipartCommitUploadPartInfo.getPartName();
            }
            if (copyHeader != null) {
                this.getMetrics().updateCopyObjectSuccessStats(startNanos);
                response = Response.ok((Object)new CopyPartResult(eTag)).build();
                return response;
            }
            this.getMetrics().updateCreateMultipartKeySuccessStats(startNanos);
            response = Response.ok().header("ETag", (Object)eTag).build();
            return response;
        }
        catch (OMException ex) {
            if (copyHeader != null) {
                this.getMetrics().updateCopyObjectFailureStats(startNanos);
            } else {
                this.getMetrics().updateCreateMultipartKeyFailureStats(startNanos);
            }
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucket + "/" + key, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.INVALID_PART) {
                OS3Exception os3Exception = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, String.valueOf(partNumber), (Exception)((Object)ex));
                os3Exception.setErrorMessage(ex.getMessage());
                throw os3Exception;
            }
            throw ex;
        }
        finally {
            if (digestInputStream != null) {
                digestInputStream.getMessageDigest().reset();
            }
        }
    }

    private Response listParts(String bucket, String key, String uploadID, int partNumberMarker, int maxParts, AuditLogger.PerformanceStringBuilder perf) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        ListPartsResponse listPartsResponse = new ListPartsResponse();
        try {
            OzoneBucket ozoneBucket = this.getBucket(bucket);
            OzoneMultipartUploadPartListParts ozoneMultipartUploadPartListParts = ozoneBucket.listParts(key, uploadID, partNumberMarker, maxParts);
            listPartsResponse.setBucket(bucket);
            listPartsResponse.setKey(key);
            listPartsResponse.setUploadID(uploadID);
            listPartsResponse.setMaxParts(maxParts);
            listPartsResponse.setPartNumberMarker(partNumberMarker);
            listPartsResponse.setTruncated(false);
            listPartsResponse.setStorageClass(S3StorageType.fromReplicationConfig(ozoneMultipartUploadPartListParts.getReplicationConfig()).toString());
            if (ozoneMultipartUploadPartListParts.isTruncated()) {
                listPartsResponse.setTruncated(ozoneMultipartUploadPartListParts.isTruncated());
                listPartsResponse.setNextPartNumberMarker(ozoneMultipartUploadPartListParts.getNextPartNumberMarker());
            }
            ozoneMultipartUploadPartListParts.getPartInfoList().forEach(partInfo -> {
                ListPartsResponse.Part part = new ListPartsResponse.Part();
                part.setPartNumber(partInfo.getPartNumber());
                part.setETag(StringUtils.isNotEmpty((CharSequence)partInfo.getETag()) ? partInfo.getETag() : partInfo.getPartName());
                part.setSize(partInfo.getSize());
                part.setLastModified(Instant.ofEpochMilli(partInfo.getModificationTime()));
                listPartsResponse.addPart(part);
            });
        }
        catch (OMException ex) {
            this.getMetrics().updateListPartsFailureStats(startNanos);
            if (ex.getResult() == OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_UPLOAD, uploadID, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucket + "/" + key + "/" + uploadID, (Exception)((Object)ex));
            }
            throw ex;
        }
        long opLatencyNs = this.getMetrics().updateListPartsSuccessStats(startNanos);
        perf.appendCount((long)listPartsResponse.getPartList().size());
        perf.appendOpLatencyNanos(opLatencyNs);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)listPartsResponse).build();
    }

    @VisibleForTesting
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @VisibleForTesting
    public void setContext(ContainerRequestContext context) {
        this.context = context;
    }

    void copy(OzoneVolume volume, DigestInputStream src, long srcKeyLen, String destKey, String destBucket, ReplicationConfig replication, Map<String, String> metadata, AuditLogger.PerformanceStringBuilder perf, long startNanos, Map<String, String> tags) throws IOException {
        long copyLength;
        if (this.datastreamEnabled && (replication == null || replication.getReplicationType() != HddsProtos.ReplicationType.EC) && srcKeyLen > this.datastreamMinLength) {
            perf.appendStreamMode();
            copyLength = ObjectEndpointStreaming.copyKeyWithStream(volume.getBucket(destBucket), destKey, srcKeyLen, this.chunkSize, replication, metadata, src, perf, startNanos, tags);
        } else {
            try (OzoneOutputStream dest = this.getClientProtocol().createKey(volume.getName(), destBucket, destKey, srcKeyLen, replication, metadata, tags);){
                long metadataLatencyNs = this.getMetrics().updateCopyKeyMetadataStats(startNanos);
                perf.appendMetaLatencyNanos(metadataLatencyNs);
                copyLength = IOUtils.copyLarge((InputStream)src, (OutputStream)dest, (long)0L, (long)srcKeyLen, (byte[])new byte[this.getIOBufferSize(srcKeyLen)]);
                String eTag = DatatypeConverter.printHexBinary((byte[])src.getMessageDigest().digest()).toLowerCase();
                dest.getMetadata().put("ETag", eTag);
            }
        }
        this.getMetrics().incCopyObjectSuccessLength(copyLength);
        perf.appendSizeBytes(copyLength);
    }

    private CopyObjectResponse copyObject(OzoneVolume volume, String copyHeader, String destBucket, String destkey, ReplicationConfig replicationConfig, boolean storageTypeDefault, AuditLogger.PerformanceStringBuilder perf) throws OS3Exception, IOException {
        long startNanos = Time.monotonicNowNanos();
        Pair<String, String> result = ObjectEndpoint.parseSourceHeader(copyHeader);
        String sourceBucket = (String)result.getLeft();
        String sourceKey = (String)result.getRight();
        DigestInputStream sourceDigestInputStream = null;
        try {
            Map<String, String> customMetadata;
            Map<String, String> tags;
            OzoneKeyDetails sourceKeyDetails = this.getClientProtocol().getKeyDetails(volume.getName(), sourceBucket, sourceKey);
            if (sourceBucket.equals(destBucket) && sourceKey.equals(destkey)) {
                if (storageTypeDefault) {
                    OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, copyHeader);
                    ex.setErrorMessage("This copy request is illegal because it is trying to copy an object to it self itself without changing the object's metadata, storage class, website redirect location or encryption attributes.");
                    throw ex;
                }
                CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
                copyObjectResponse.setETag(ObjectEndpoint.wrapInQuotes((String)sourceKeyDetails.getMetadata().get("ETag")));
                copyObjectResponse.setLastModified(Instant.ofEpochMilli(Time.now()));
                CopyObjectResponse copyObjectResponse2 = copyObjectResponse;
                return copyObjectResponse2;
            }
            long sourceKeyLen = sourceKeyDetails.getDataSize();
            String tagCopyDirective = this.headers.getHeaderString("x-amz-tagging-directive");
            if (StringUtils.isEmpty((CharSequence)tagCopyDirective) || tagCopyDirective.equals(S3Consts.CopyDirective.COPY.name())) {
                tags = sourceKeyDetails.getTags();
            } else if (tagCopyDirective.equals(S3Consts.CopyDirective.REPLACE.name())) {
                tags = this.getTaggingFromHeaders(this.headers);
            } else {
                OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, tagCopyDirective);
                ex.setErrorMessage("An error occurred (InvalidArgument) when calling the CopyObject operation: The tagging copy directive specified is invalid. Valid values are COPY or REPLACE.");
                throw ex;
            }
            String metadataCopyDirective = this.headers.getHeaderString("x-amz-metadata-directive");
            if (StringUtils.isEmpty((CharSequence)metadataCopyDirective) || metadataCopyDirective.equals(S3Consts.CopyDirective.COPY.name())) {
                customMetadata = sourceKeyDetails.getMetadata();
            } else if (metadataCopyDirective.equals(S3Consts.CopyDirective.REPLACE.name())) {
                customMetadata = this.getCustomMetadataFromHeaders((MultivaluedMap<String, String>)this.headers.getRequestHeaders());
            } else {
                OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, metadataCopyDirective);
                ex.setErrorMessage("An error occurred (InvalidArgument) when calling the CopyObject operation: The metadata copy directive specified is invalid. Valid values are COPY or REPLACE.");
                throw ex;
            }
            try (OzoneInputStream src = this.getClientProtocol().getKey(volume.getName(), sourceBucket, sourceKey);){
                this.getMetrics().updateCopyKeyMetadataStats(startNanos);
                sourceDigestInputStream = new DigestInputStream((InputStream)src, this.getMessageDigestInstance());
                this.copy(volume, sourceDigestInputStream, sourceKeyLen, destkey, destBucket, replicationConfig, customMetadata, perf, startNanos, tags);
            }
            OzoneKeyDetails destKeyDetails = this.getClientProtocol().getKeyDetails(volume.getName(), destBucket, destkey);
            this.getMetrics().updateCopyObjectSuccessStats(startNanos);
            CopyObjectResponse copyObjectResponse = new CopyObjectResponse();
            copyObjectResponse.setETag(ObjectEndpoint.wrapInQuotes((String)destKeyDetails.getMetadata().get("ETag")));
            copyObjectResponse.setLastModified(destKeyDetails.getModificationTime());
            CopyObjectResponse copyObjectResponse3 = copyObjectResponse;
            return copyObjectResponse3;
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, sourceKey, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, sourceBucket, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, destBucket + "/" + destkey, (Exception)((Object)ex));
            }
            throw ex;
        }
        finally {
            if (sourceDigestInputStream != null) {
                sourceDigestInputStream.getMessageDigest().reset();
            }
        }
    }

    @VisibleForTesting
    public static Pair<String, String> parseSourceHeader(String copyHeader) throws OS3Exception {
        int pos;
        String header = copyHeader;
        if (header.startsWith("/")) {
            header = copyHeader.substring(1);
        }
        if ((pos = header.indexOf(47)) == -1) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, header);
            ex.setErrorMessage("Copy Source must mention the source bucket and key: sourcebucket/sourcekey");
            throw ex;
        }
        try {
            String bucket = header.substring(0, pos);
            String key = S3Utils.urlDecode(header.substring(pos + 1));
            return Pair.of((Object)bucket, (Object)key);
        }
        catch (UnsupportedEncodingException e) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, header, e);
            ex.setErrorMessage("Copy Source header could not be url-decoded");
            throw ex;
        }
    }

    private static int parsePartNumberMarker(String partNumberMarker) {
        int partMarker = 0;
        if (partNumberMarker != null) {
            partMarker = Integer.parseInt(partNumberMarker);
        }
        return partMarker;
    }

    private static OptionalLong parseAndValidateDate(String ozoneDateStr) {
        long ozoneDateInMs;
        if (ozoneDateStr == null) {
            return OptionalLong.empty();
        }
        try {
            ozoneDateInMs = OzoneUtils.formatDate((String)ozoneDateStr);
        }
        catch (ParseException e) {
            return OptionalLong.empty();
        }
        long currentDate = System.currentTimeMillis();
        if (ozoneDateInMs <= currentDate) {
            return OptionalLong.of(ozoneDateInMs);
        }
        return OptionalLong.empty();
    }

    public static boolean checkCopySourceModificationTime(Long lastModificationTime, String copySourceIfModifiedSinceStr, String copySourceIfUnmodifiedSinceStr) {
        OptionalLong unmodifiedDate;
        long copySourceIfModifiedSince = Long.MIN_VALUE;
        long copySourceIfUnmodifiedSince = Long.MAX_VALUE;
        OptionalLong modifiedDate = ObjectEndpoint.parseAndValidateDate(copySourceIfModifiedSinceStr);
        if (modifiedDate.isPresent()) {
            copySourceIfModifiedSince = modifiedDate.getAsLong();
        }
        if ((unmodifiedDate = ObjectEndpoint.parseAndValidateDate(copySourceIfUnmodifiedSinceStr)).isPresent()) {
            copySourceIfUnmodifiedSince = unmodifiedDate.getAsLong();
        }
        return copySourceIfModifiedSince <= lastModificationTime && lastModificationTime <= copySourceIfUnmodifiedSince;
    }

    private Response putObjectTagging(OzoneVolume volume, String bucketName, String keyName, InputStream body) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3Tagging tagging = null;
        try {
            tagging = (S3Tagging)new PutTaggingUnmarshaller().readFrom(body);
            tagging.validate();
        }
        catch (Exception ex) {
            OS3Exception exception = S3ErrorTable.newError(S3ErrorTable.MALFORMED_XML, keyName);
            exception.setErrorMessage(exception.getErrorMessage() + ". " + ex.getMessage());
            throw exception;
        }
        Map<String, String> tags = ObjectEndpoint.validateAndGetTagging(tagging.getTagSet().getTags(), S3Tagging.Tag::getKey, S3Tagging.Tag::getValue);
        try {
            volume.getBucket(bucketName).putObjectTagging(keyName, tags);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.INVALID_REQUEST) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_REQUEST, keyName);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, keyName);
            }
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, keyName);
            }
            if (ex.getResult() == OMException.ResultCodes.NOT_SUPPORTED_OPERATION) {
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, keyName);
            }
            throw ex;
        }
        this.getMetrics().updatePutObjectTaggingSuccessStats(startNanos);
        return Response.ok().build();
    }

    private Response getObjectTagging(String bucketName, String keyName) throws IOException {
        long startNanos = Time.monotonicNowNanos();
        OzoneVolume volume = this.getVolume();
        Map tagMap = volume.getBucket(bucketName).getObjectTagging(keyName);
        this.getMetrics().updateGetObjectTaggingSuccessStats(startNanos);
        return Response.ok((Object)S3Tagging.fromMap(tagMap), (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private Response deleteObjectTagging(OzoneVolume volume, String bucketName, String keyName) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        try {
            volume.getBucket(bucketName).deleteObjectTagging(keyName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_KEY, keyName);
            }
            throw ex;
        }
        this.getMetrics().updateDeleteObjectTaggingSuccessStats(startNanos);
        return Response.noContent().build();
    }

    @VisibleForTesting
    public void setOzoneConfiguration(OzoneConfiguration config) {
        this.ozoneConfiguration = config;
    }

    @VisibleForTesting
    public boolean isDatastreamEnabled() {
        return this.datastreamEnabled;
    }

    static String wrapInQuotes(String value) {
        return "\"" + value + "\"";
    }

    @VisibleForTesting
    public MessageDigest getMessageDigestInstance() {
        return E_TAG_PROVIDER.get();
    }

    private String extractPartsCount(String eTag) {
        if (eTag.contains("-")) {
            String[] parts = eTag.replace("\"", "").split("-");
            String lastPart = parts[parts.length - 1];
            return lastPart.matches("\\d+") ? lastPart : null;
        }
        return null;
    }

    private int getIOBufferSize(long fileLength) {
        if (this.bufferSize == 0) {
            LOG.warn("buffer size is set to {}", (Object)8192);
            this.bufferSize = 8192;
        }
        if (fileLength == 0L) {
            return this.bufferSize;
        }
        return fileLength < (long)this.bufferSize ? (int)fileLength : this.bufferSize;
    }
}

