/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskDbEventHandler;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskWithLegacy
extends NSSummaryTaskDbEventHandler {
    private static final BucketLayout LEGACY_BUCKET_LAYOUT = BucketLayout.LEGACY;
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskWithLegacy.class);
    private final boolean enableFileSystemPaths;
    private final long nsSummaryFlushToDBMaxThreshold;

    public NSSummaryTaskWithLegacy(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration, long nsSummaryFlushToDBMaxThreshold) {
        super(reconNamespaceSummaryManager, reconOMMetadataManager);
        this.enableFileSystemPaths = ozoneConfiguration.getBoolean("ozone.om.enable.filesystem.paths", false);
        this.nsSummaryFlushToDBMaxThreshold = nsSummaryFlushToDBMaxThreshold;
    }

    public Pair<Integer, Boolean> processWithLegacy(OMUpdateEventBatch events, int seekPos) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        for (int itrPos = 0; eventIterator.hasNext() && itrPos < seekPos; ++itrPos) {
            eventIterator.next();
        }
        int eventCounter = 0;
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        ReconOMMetadataManager metadataManager = this.getReconOMMetadataManager();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            OMDBUpdateEvent.OMDBUpdateAction action = omdbUpdateEvent.getAction();
            ++eventCounter;
            String table = omdbUpdateEvent.getTable();
            if (!table.equals("keyTable")) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            try {
                OMDBUpdateEvent keyTableUpdateEvent = omdbUpdateEvent;
                Object value = keyTableUpdateEvent.getValue();
                Object oldValue = keyTableUpdateEvent.getOldValue();
                if (!(value instanceof OmKeyInfo)) {
                    LOG.warn("Unexpected value type {} for key {}. Skipping processing.", (Object)value.getClass().getName(), (Object)updatedKey);
                    continue;
                }
                OmKeyInfo updatedKeyInfo = (OmKeyInfo)value;
                OmKeyInfo oldKeyInfo = (OmKeyInfo)oldValue;
                if (!this.isBucketLayoutValid(metadataManager, updatedKeyInfo)) continue;
                if (this.enableFileSystemPaths) {
                    this.processWithFileSystemLayout(updatedKeyInfo, oldKeyInfo, action, nsSummaryMap);
                } else {
                    this.processWithObjectStoreLayout(updatedKeyInfo, oldKeyInfo, action, nsSummaryMap);
                }
            }
            catch (IOException ioEx) {
                LOG.error("Unable to process Namespace Summary data in Recon DB. ", (Throwable)ioEx);
                nsSummaryMap.clear();
                return new ImmutablePair((Object)seekPos, (Object)false);
            }
            if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold) continue;
            if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
                return new ImmutablePair((Object)seekPos, (Object)false);
            }
            seekPos = eventCounter + 1;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return new ImmutablePair((Object)seekPos, (Object)false);
        }
        LOG.debug("Completed a process run of NSSummaryTaskWithLegacy");
        return new ImmutablePair((Object)seekPos, (Object)true);
    }

    private void processWithFileSystemLayout(OmKeyInfo updatedKeyInfo, OmKeyInfo oldKeyInfo, OMDBUpdateEvent.OMDBUpdateAction action, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        this.setKeyParentID(updatedKeyInfo);
        if (!updatedKeyInfo.getKeyName().endsWith("/")) {
            switch (action) {
                case PUT: {
                    this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                    break;
                }
                case DELETE: {
                    this.handleDeleteKeyEvent(updatedKeyInfo, nsSummaryMap);
                    break;
                }
                case UPDATE: {
                    if (oldKeyInfo != null) {
                        this.setKeyParentID(oldKeyInfo);
                        this.handleDeleteKeyEvent(oldKeyInfo, nsSummaryMap);
                    } else {
                        LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKeyInfo.getKeyName());
                    }
                    this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                    break;
                }
                default: {
                    LOG.debug("Skipping DB update event for Key: {}", (Object)action);
                    break;
                }
            }
        } else {
            OmDirectoryInfo updatedDirectoryInfo = new OmDirectoryInfo.Builder().setName(updatedKeyInfo.getKeyName()).setObjectID(updatedKeyInfo.getObjectID()).setParentObjectID(updatedKeyInfo.getParentObjectID()).build();
            OmDirectoryInfo oldDirectoryInfo = null;
            if (oldKeyInfo != null) {
                oldDirectoryInfo = new OmDirectoryInfo.Builder().setName(oldKeyInfo.getKeyName()).setObjectID(oldKeyInfo.getObjectID()).setParentObjectID(oldKeyInfo.getParentObjectID()).build();
            }
            switch (action) {
                case PUT: {
                    this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                    break;
                }
                case DELETE: {
                    this.handleDeleteDirEvent(updatedDirectoryInfo, nsSummaryMap);
                    break;
                }
                case UPDATE: {
                    if (oldDirectoryInfo != null) {
                        this.handleDeleteDirEvent(oldDirectoryInfo, nsSummaryMap);
                    } else {
                        LOG.warn("Update event does not have the old dirInfo for {}.", (Object)updatedKeyInfo.getKeyName());
                    }
                    this.handlePutDirEvent(updatedDirectoryInfo, nsSummaryMap);
                    break;
                }
                default: {
                    LOG.debug("Skipping DB update event for Directory: {}", (Object)action);
                }
            }
        }
    }

    private void processWithObjectStoreLayout(OmKeyInfo updatedKeyInfo, OmKeyInfo oldKeyInfo, OMDBUpdateEvent.OMDBUpdateAction action, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        this.setParentBucketId(updatedKeyInfo);
        switch (action) {
            case PUT: {
                this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            case DELETE: {
                this.handleDeleteKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            case UPDATE: {
                if (oldKeyInfo != null) {
                    this.setParentBucketId(oldKeyInfo);
                    this.handleDeleteKeyEvent(oldKeyInfo, nsSummaryMap);
                } else {
                    LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKeyInfo.getKeyName());
                }
                this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                break;
            }
            default: {
                LOG.debug("Skipping DB update event for Key: {}", (Object)action);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reprocessWithLegacy(OMMetadataManager omMetadataManager) {
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        try {
            Table keyTable = omMetadataManager.getKeyTable(LEGACY_BUCKET_LAYOUT);
            try (Table.KeyValueIterator keyTableIter = keyTable.iterator();){
                while (keyTableIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyTableIter.next();
                    OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                    if (!this.isBucketLayoutValid((ReconOMMetadataManager)omMetadataManager, keyInfo)) continue;
                    if (this.enableFileSystemPaths) {
                        this.setKeyParentID(keyInfo);
                        if (keyInfo.getKeyName().endsWith("/")) {
                            OmDirectoryInfo directoryInfo = new OmDirectoryInfo.Builder().setName(keyInfo.getKeyName()).setObjectID(keyInfo.getObjectID()).setParentObjectID(keyInfo.getParentObjectID()).build();
                            this.handlePutDirEvent(directoryInfo, nsSummaryMap);
                        } else {
                            this.handlePutKeyEvent(keyInfo, nsSummaryMap);
                        }
                    } else {
                        this.setParentBucketId(keyInfo);
                        this.handlePutKeyEvent(keyInfo, nsSummaryMap);
                    }
                    if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold || this.flushAndCommitNSToDB(nsSummaryMap)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to reprocess Namespace Summary data in Recon DB. ", (Throwable)ioEx);
            nsSummaryMap.clear();
            return false;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return false;
        }
        LOG.debug("Completed a reprocess run of NSSummaryTaskWithLegacy");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setKeyParentID(OmKeyInfo keyInfo) throws IOException {
        String[] keyPath = keyInfo.getKeyName().split("/");
        if (keyPath.length <= 1) {
            this.setParentBucketId(keyInfo);
            return;
        }
        CharSequence[] dirs = Arrays.copyOf(keyPath, keyPath.length - 1);
        String parentKeyName = String.join((CharSequence)"/", dirs);
        parentKeyName = parentKeyName + "/";
        String fullParentKeyName = this.getReconOMMetadataManager().getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), parentKeyName);
        OmKeyInfo parentKeyInfo = (OmKeyInfo)this.getReconOMMetadataManager().getKeyTable(LEGACY_BUCKET_LAYOUT).getSkipCache((Object)fullParentKeyName);
        if (parentKeyInfo != null) {
            keyInfo.setParentObjectID(parentKeyInfo.getObjectID());
            return;
        }
        LOG.warn("ParentKeyInfo is null for key: {} in volume: {}, bucket: {}. Full Parent Key: {}", new Object[]{keyInfo.getKeyName(), keyInfo.getVolumeName(), keyInfo.getBucketName(), fullParentKeyName});
        throw new IOException("ParentKeyInfo for NSSummaryTaskWithLegacy is null for key: " + keyInfo.getKeyName());
    }

    private void setParentBucketId(OmKeyInfo keyInfo) throws IOException {
        String bucketKey = this.getReconOMMetadataManager().getBucketKey(keyInfo.getVolumeName(), keyInfo.getBucketName());
        OmBucketInfo parentBucketInfo = (OmBucketInfo)this.getReconOMMetadataManager().getBucketTable().getSkipCache((Object)bucketKey);
        if (parentBucketInfo == null) {
            LOG.warn("ParentBucketInfo is null for key: {} in volume: {}, bucket: {}", new Object[]{keyInfo.getKeyName(), keyInfo.getVolumeName(), keyInfo.getBucketName()});
            throw new IOException("ParentBucketInfo for NSSummaryTaskWithLegacy is null for key: " + keyInfo.getKeyName());
        }
        keyInfo.setParentObjectID(parentBucketInfo.getObjectID());
    }

    private boolean isBucketLayoutValid(ReconOMMetadataManager metadataManager, OmKeyInfo keyInfo) throws IOException {
        String volumeName = keyInfo.getVolumeName();
        String bucketName = keyInfo.getBucketName();
        String bucketDBKey = metadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)metadataManager.getBucketTable().getSkipCache((Object)bucketDBKey);
        if (omBucketInfo.getBucketLayout() != LEGACY_BUCKET_LAYOUT) {
            LOG.debug("Skipping processing for bucket {} as bucket layout is not LEGACY", (Object)bucketName);
            return false;
        }
        return true;
    }
}

